package software.aws.pdk.type_safe_api;

/**
 * Options required alongside an Open API specification to create API Gateway resources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.587Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.TypeSafeApiOptions")
@software.amazon.jsii.Jsii.Proxy(TypeSafeApiOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TypeSafeApiOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A mapping of API operation to its integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration> getIntegrations();

    /**
     * Details about each operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> getOperationLookup();

    /**
     * Options for API keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.ApiKeyOptions getApiKeyOptions() {
        return null;
    }

    /**
     * Cross Origin Resource Sharing options for the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CorsOptions getCorsOptions() {
        return null;
    }

    /**
     * The default authorizer to use for your api.
     * <p>
     * When omitted, no default authorizer is used.
     * Authorizers specified at the integration level will override this for that operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.Authorizer getDefaultAuthorizer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TypeSafeApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TypeSafeApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TypeSafeApiOptions> {
        java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration> integrations;
        java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> operationLookup;
        software.aws.pdk.type_safe_api.ApiKeyOptions apiKeyOptions;
        software.amazon.awscdk.services.apigateway.CorsOptions corsOptions;
        software.aws.pdk.type_safe_api.Authorizer defaultAuthorizer;

        /**
         * Sets the value of {@link TypeSafeApiOptions#getIntegrations}
         * @param integrations A mapping of API operation to its integration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder integrations(java.util.Map<java.lang.String, ? extends software.aws.pdk.type_safe_api.TypeSafeApiIntegration> integrations) {
            this.integrations = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration>)integrations;
            return this;
        }

        /**
         * Sets the value of {@link TypeSafeApiOptions#getOperationLookup}
         * @param operationLookup Details about each operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder operationLookup(java.util.Map<java.lang.String, ? extends software.aws.pdk.type_safe_api.OperationDetails> operationLookup) {
            this.operationLookup = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails>)operationLookup;
            return this;
        }

        /**
         * Sets the value of {@link TypeSafeApiOptions#getApiKeyOptions}
         * @param apiKeyOptions Options for API keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyOptions(software.aws.pdk.type_safe_api.ApiKeyOptions apiKeyOptions) {
            this.apiKeyOptions = apiKeyOptions;
            return this;
        }

        /**
         * Sets the value of {@link TypeSafeApiOptions#getCorsOptions}
         * @param corsOptions Cross Origin Resource Sharing options for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsOptions(software.amazon.awscdk.services.apigateway.CorsOptions corsOptions) {
            this.corsOptions = corsOptions;
            return this;
        }

        /**
         * Sets the value of {@link TypeSafeApiOptions#getDefaultAuthorizer}
         * @param defaultAuthorizer The default authorizer to use for your api.
         *                          When omitted, no default authorizer is used.
         *                          Authorizers specified at the integration level will override this for that operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorizer(software.aws.pdk.type_safe_api.Authorizer defaultAuthorizer) {
            this.defaultAuthorizer = defaultAuthorizer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TypeSafeApiOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TypeSafeApiOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TypeSafeApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TypeSafeApiOptions {
        private final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration> integrations;
        private final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> operationLookup;
        private final software.aws.pdk.type_safe_api.ApiKeyOptions apiKeyOptions;
        private final software.amazon.awscdk.services.apigateway.CorsOptions corsOptions;
        private final software.aws.pdk.type_safe_api.Authorizer defaultAuthorizer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integrations = software.amazon.jsii.Kernel.get(this, "integrations", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.TypeSafeApiIntegration.class)));
            this.operationLookup = software.amazon.jsii.Kernel.get(this, "operationLookup", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.OperationDetails.class)));
            this.apiKeyOptions = software.amazon.jsii.Kernel.get(this, "apiKeyOptions", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.ApiKeyOptions.class));
            this.corsOptions = software.amazon.jsii.Kernel.get(this, "corsOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CorsOptions.class));
            this.defaultAuthorizer = software.amazon.jsii.Kernel.get(this, "defaultAuthorizer", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.Authorizer.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integrations = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration>)java.util.Objects.requireNonNull(builder.integrations, "integrations is required");
            this.operationLookup = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails>)java.util.Objects.requireNonNull(builder.operationLookup, "operationLookup is required");
            this.apiKeyOptions = builder.apiKeyOptions;
            this.corsOptions = builder.corsOptions;
            this.defaultAuthorizer = builder.defaultAuthorizer;
        }

        @Override
        public final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.TypeSafeApiIntegration> getIntegrations() {
            return this.integrations;
        }

        @Override
        public final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> getOperationLookup() {
            return this.operationLookup;
        }

        @Override
        public final software.aws.pdk.type_safe_api.ApiKeyOptions getApiKeyOptions() {
            return this.apiKeyOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.CorsOptions getCorsOptions() {
            return this.corsOptions;
        }

        @Override
        public final software.aws.pdk.type_safe_api.Authorizer getDefaultAuthorizer() {
            return this.defaultAuthorizer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integrations", om.valueToTree(this.getIntegrations()));
            data.set("operationLookup", om.valueToTree(this.getOperationLookup()));
            if (this.getApiKeyOptions() != null) {
                data.set("apiKeyOptions", om.valueToTree(this.getApiKeyOptions()));
            }
            if (this.getCorsOptions() != null) {
                data.set("corsOptions", om.valueToTree(this.getCorsOptions()));
            }
            if (this.getDefaultAuthorizer() != null) {
                data.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.TypeSafeApiOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TypeSafeApiOptions.Jsii$Proxy that = (TypeSafeApiOptions.Jsii$Proxy) o;

            if (!integrations.equals(that.integrations)) return false;
            if (!operationLookup.equals(that.operationLookup)) return false;
            if (this.apiKeyOptions != null ? !this.apiKeyOptions.equals(that.apiKeyOptions) : that.apiKeyOptions != null) return false;
            if (this.corsOptions != null ? !this.corsOptions.equals(that.corsOptions) : that.corsOptions != null) return false;
            return this.defaultAuthorizer != null ? this.defaultAuthorizer.equals(that.defaultAuthorizer) : that.defaultAuthorizer == null;
        }

        @Override
        public final int hashCode() {
            int result = this.integrations.hashCode();
            result = 31 * result + (this.operationLookup.hashCode());
            result = 31 * result + (this.apiKeyOptions != null ? this.apiKeyOptions.hashCode() : 0);
            result = 31 * result + (this.corsOptions != null ? this.corsOptions.hashCode() : 0);
            result = 31 * result + (this.defaultAuthorizer != null ? this.defaultAuthorizer.hashCode() : 0);
            return result;
        }
    }
}
