/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.CanCollectPerformanceMetrics;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareTimeMetricsHolder;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.shading.com.mysql.cj.util.ExpiringCache;

public class AuroraTopologyService
implements TopologyService,
CanCollectPerformanceMetrics {
    static final int DEFAULT_REFRESH_RATE_IN_MILLISECONDS = 30000;
    static final int DEFAULT_CACHE_EXPIRE_MS = 300000;
    private int refreshRateInMilliseconds;
    static final String RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID, LAST_UPDATE_TIMESTAMP, REPLICA_LAG_IN_MILLISECONDS FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 ORDER BY LAST_UPDATE_TIMESTAMP DESC";
    static final String GET_INSTANCE_NAME_SQL = "SELECT @@aurora_server_id";
    static final String GET_INSTANCE_NAME_COL = "@@aurora_server_id";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String FIELD_SERVER_ID = "SERVER_ID";
    static final String FIELD_SESSION_ID = "SESSION_ID";
    static final String FIELD_LAST_UPDATED = "LAST_UPDATE_TIMESTAMP";
    static final String FIELD_REPLICA_LAG = "REPLICA_LAG_IN_MILLISECONDS";
    protected static final int NO_CONNECTION_INDEX = -1;
    protected static final ExpiringCache<String, ClusterTopologyInfo> topologyCache = new ExpiringCache(300000);
    private static final Object cacheLock = new Object();
    protected String clusterId;
    protected HostInfo clusterInstanceHost;
    protected ClusterAwareTimeMetricsHolder queryTopologyMetrics = new ClusterAwareTimeMetricsHolder("Topology Query");
    protected boolean gatherPerfMetrics = false;

    public AuroraTopologyService() {
        this(30000);
    }

    public AuroraTopologyService(int refreshRateInMilliseconds) {
        this.refreshRateInMilliseconds = refreshRateInMilliseconds;
        this.clusterId = UUID.randomUUID().toString();
        this.clusterInstanceHost = new HostInfo(null, "?", -1, null, null);
    }

    public static void setExpireTime(int expireTimeMs) {
        topologyCache.setExpireTime(expireTimeMs);
    }

    @Override
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public void setClusterInstanceHost(HostInfo clusterInstanceHost) {
        this.clusterInstanceHost = clusterInstanceHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HostInfo> getTopology(JdbcConnection conn, boolean forceUpdate) {
        ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
        if (clusterTopologyInfo == null || clusterTopologyInfo.hosts == null || forceUpdate || this.refreshNeeded(clusterTopologyInfo)) {
            ClusterTopologyInfo latestTopologyInfo = this.queryForTopology(conn);
            if (latestTopologyInfo != null && latestTopologyInfo.hosts != null) {
                Object object = cacheLock;
                synchronized (object) {
                    if (clusterTopologyInfo == null) {
                        clusterTopologyInfo = new ClusterTopologyInfo();
                    }
                    clusterTopologyInfo.hosts = latestTopologyInfo.hosts;
                    clusterTopologyInfo.isMultiWriterCluster = latestTopologyInfo.isMultiWriterCluster;
                    clusterTopologyInfo.lastUpdated = Instant.now();
                    clusterTopologyInfo.downHosts = new HashSet<String>();
                    topologyCache.put(this.clusterId, clusterTopologyInfo);
                }
            } else {
                return clusterTopologyInfo == null || forceUpdate ? null : clusterTopologyInfo.hosts;
            }
        }
        return clusterTopologyInfo.hosts;
    }

    private boolean refreshNeeded(ClusterTopologyInfo info) {
        Instant lastUpdateTime = info.lastUpdated;
        return lastUpdateTime == null || Duration.between(lastUpdateTime, Instant.now()).toMillis() > (long)this.refreshRateInMilliseconds;
    }

    protected ClusterTopologyInfo queryForTopology(JdbcConnection conn) {
        long startTimeMs = this.gatherPerfMetrics ? System.currentTimeMillis() : 0L;
        ClusterTopologyInfo result = new ClusterTopologyInfo();
        try (Statement stmt2 = conn.createStatement();
             ResultSet resultSet = stmt2.executeQuery(RETRIEVE_TOPOLOGY_SQL);){
            result.hosts = new ArrayList<HostInfo>();
            result.hosts.add(null);
            int writerCount = 0;
            int i = 1;
            while (resultSet.next()) {
                if (WRITER_SESSION_ID.equalsIgnoreCase(resultSet.getString(FIELD_SESSION_ID))) {
                    if (writerCount == 0) {
                        result.hosts.set(0, this.createHost(resultSet));
                    } else {
                        result.hosts.add(i, this.createHost(resultSet));
                        ++i;
                    }
                    ++writerCount;
                    continue;
                }
                result.hosts.add(i, this.createHost(resultSet));
                ++i;
            }
            result.isMultiWriterCluster = writerCount > 1;
        }
        catch (SQLException stmt2) {
            // empty catch block
        }
        if (this.gatherPerfMetrics) {
            long currentTimeMs = System.currentTimeMillis();
            this.queryTopologyMetrics.registerQueryExecutionTime(currentTimeMs - startTimeMs);
        }
        return result;
    }

    private HostInfo createHost(ResultSet resultSet) throws SQLException {
        String hostEndpoint = this.getHostEndpoint(resultSet.getString(FIELD_SERVER_ID));
        ConnectionUrl hostUrl = ConnectionUrl.getConnectionUrlInstance(this.getUrlFromEndpoint(hostEndpoint, this.clusterInstanceHost.getPort(), this.clusterInstanceHost.getDatabase()), new Properties());
        return new HostInfo(hostUrl, hostEndpoint, this.clusterInstanceHost.getPort(), this.clusterInstanceHost.getUser(), this.clusterInstanceHost.getPassword(), this.clusterInstanceHost.isPasswordless(), this.getPropertiesFromTopology(resultSet));
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceHost.getHost();
        return host.replace("?", nodeName);
    }

    private String getUrlFromEndpoint(String endpoint, int port, String dbname) {
        return String.format("%s//%s:%d/%s", ConnectionUrl.Type.SINGLE_CONNECTION_AWS.getScheme(), endpoint, port, dbname);
    }

    private Map<String, String> getPropertiesFromTopology(ResultSet resultSet) throws SQLException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.clusterInstanceHost != null) {
            properties.putAll(this.clusterInstanceHost.getHostProperties());
        }
        properties.put("TOPOLOGY_SERVICE_SERVER_ID", resultSet.getString(FIELD_SERVER_ID));
        properties.put("TOPOLOGY_SERVICE_SESSION_ID", resultSet.getString(FIELD_SESSION_ID));
        properties.put("TOPOLOGY_SERVICE_LAST_UPDATE_TIMESTAMP", this.convertTimestampToString(resultSet.getTimestamp(FIELD_LAST_UPDATED)));
        properties.put("TOPOLOGY_SERVICE_REPLICA_LAG_IN_MILLISECONDS", Double.valueOf(resultSet.getDouble(FIELD_REPLICA_LAG)).toString());
        return properties;
    }

    private String convertTimestampToString(Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toString();
    }

    @Override
    public List<HostInfo> getCachedTopology() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.hosts;
    }

    @Override
    public HostInfo getLastUsedReaderHost() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.lastUsedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUsedReaderHost(HostInfo reader) {
        if (reader != null) {
            Object object = cacheLock;
            synchronized (object) {
                ClusterTopologyInfo info = topologyCache.get(this.clusterId);
                if (info != null) {
                    info.lastUsedReader = reader;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public HostInfo getHostByName(JdbcConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HostInfo instanceNameToHost(String name, List<HostInfo> hosts) {
        if (name == null || hosts == null) {
            return null;
        }
        for (HostInfo host : hosts) {
            if (host == null || !name.equalsIgnoreCase(host.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"))) continue;
            return host;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDownHosts() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null ? clusterTopologyInfo.downHosts : new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToDownHostList(HostInfo downHost) {
        if (downHost == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo == null) {
                clusterTopologyInfo = new ClusterTopologyInfo();
                topologyCache.put(this.clusterId, clusterTopologyInfo);
            }
            if (clusterTopologyInfo.downHosts == null) {
                clusterTopologyInfo.downHosts = new HashSet<String>();
            }
            clusterTopologyInfo.downHosts.add(downHost.getHostPortPair());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDownHostList(HostInfo host) {
        if (host == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null) {
                clusterTopologyInfo.downHosts.remove(host.getHostPortPair());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMultiWriterCluster() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null && clusterTopologyInfo.isMultiWriterCluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshRate(int refreshRate) {
        this.refreshRateInMilliseconds = refreshRate;
        if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
            Object object = cacheLock;
            synchronized (object) {
                if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
                    topologyCache.setExpireTime(this.refreshRateInMilliseconds);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.remove(this.clusterId);
        }
    }

    @Override
    public void setPerformanceMetricsEnabled(boolean isEnabled) {
        this.gatherPerfMetrics = isEnabled;
    }

    @Override
    public void reportMetrics(Log log) {
        this.queryTopologyMetrics.reportMetrics(log);
        StringBuilder logMessage = new StringBuilder(256);
        logMessage.append("** Cached Topology Keys **\n");
        topologyCache.keySet().forEach(x -> logMessage.append("'").append((String)x).append("'\n"));
        log.logInfo(logMessage);
    }

    private static class ClusterTopologyInfo {
        public boolean isMultiWriterCluster;
        public Instant lastUpdated;
        public Set<String> downHosts;
        public List<HostInfo> hosts;
        public HostInfo lastUsedReader;

        private ClusterTopologyInfo() {
        }
    }
}

