/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class Monitor
implements IMonitor {
    private static final int THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    private final Queue<MonitorConnectionContext> contexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final ConnectionProvider connectionProvider;
    private final Log logger;
    private final PropertySet propertySet;
    private final HostInfo hostInfo;
    private Connection monitoringConn = null;
    private int connectionCheckIntervalMillis = Integer.MAX_VALUE;
    private final AtomicLong lastContextUsedTimestamp = new AtomicLong();
    private final long monitorDisposalTime;
    private final IMonitorService monitorService;
    private final AtomicBoolean stopped = new AtomicBoolean(true);

    public Monitor(ConnectionProvider connectionProvider, HostInfo hostInfo, PropertySet propertySet, long monitorDisposalTime, IMonitorService monitorService, Log logger) {
        this.connectionProvider = connectionProvider;
        this.hostInfo = hostInfo;
        this.propertySet = propertySet;
        this.logger = logger;
        this.monitorDisposalTime = monitorDisposalTime;
        this.monitorService = monitorService;
    }

    @Override
    public synchronized void startMonitoring(MonitorConnectionContext context) {
        this.connectionCheckIntervalMillis = Math.min(this.connectionCheckIntervalMillis, context.getFailureDetectionIntervalMillis());
        long currentTime = this.getCurrentTimeMillis();
        context.setStartMonitorTime(currentTime);
        this.lastContextUsedTimestamp.set(currentTime);
        this.contexts.add(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            this.logger.logWarn(NullArgumentMessage.getMessage("context"));
            return;
        }
        MonitorConnectionContext monitorConnectionContext = context;
        synchronized (monitorConnectionContext) {
            this.contexts.remove(context);
            context.invalidate();
        }
        this.connectionCheckIntervalMillis = this.findShortestIntervalMillis();
    }

    @Override
    public synchronized void clearContexts() {
        this.contexts.clear();
        this.connectionCheckIntervalMillis = this.findShortestIntervalMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped.set(false);
            while (true) {
                if (!this.contexts.isEmpty()) {
                    long currentTime = this.getCurrentTimeMillis();
                    this.lastContextUsedTimestamp.set(currentTime);
                    ConnectionStatus status = this.checkConnectionStatus(this.getConnectionCheckIntervalMillis());
                    for (MonitorConnectionContext monitorContext : this.contexts) {
                        monitorContext.updateConnectionStatus(currentTime, status.isValid);
                    }
                    TimeUnit.MILLISECONDS.sleep(Math.max(0L, (long)this.getConnectionCheckIntervalMillis() - status.elapsedTime));
                    continue;
                }
                if (this.getCurrentTimeMillis() - this.lastContextUsedTimestamp.get() >= this.monitorDisposalTime) {
                    this.monitorService.notifyUnused(this);
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.stopped.set(true);
        }
    }

    ConnectionStatus checkConnectionStatus(int shortestFailureDetectionIntervalMillis) {
        long start = this.getCurrentTimeMillis();
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                HashMap<String, String> monitoringConnProperties = new HashMap<String, String>();
                Properties originalProperties = this.propertySet.exposeAsProperties();
                if (originalProperties != null) {
                    originalProperties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), originalProperties.getProperty((String)p)));
                }
                start = this.getCurrentTimeMillis();
                this.monitoringConn = this.connectionProvider.connect(this.copy(this.hostInfo, monitoringConnProperties));
                return new ConnectionStatus(true, this.getCurrentTimeMillis() - start);
            }
            start = this.getCurrentTimeMillis();
            boolean isValid = this.monitoringConn.isValid(shortestFailureDetectionIntervalMillis / 1000);
            return new ConnectionStatus(isValid, this.getCurrentTimeMillis() - start);
        }
        catch (SQLException sqlEx) {
            return new ConnectionStatus(false, this.getCurrentTimeMillis() - start);
        }
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    int getConnectionCheckIntervalMillis() {
        if (this.connectionCheckIntervalMillis == Integer.MAX_VALUE) {
            return 0;
        }
        return this.connectionCheckIntervalMillis;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    private HostInfo copy(HostInfo src, Map<String, String> props) {
        return new HostInfo(null, src.getHost(), src.getPort(), src.getUser(), src.getPassword(), src.isPasswordless(), props);
    }

    private int findShortestIntervalMillis() {
        if (this.contexts.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return this.contexts.stream().min(Comparator.comparing(MonitorConnectionContext::getFailureDetectionIntervalMillis)).map(MonitorConnectionContext::getFailureDetectionIntervalMillis).orElse(0);
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTime;

        ConnectionStatus(boolean isValid, long elapsedTime) {
            this.isValid = isValid;
            this.elapsedTime = elapsedTime;
        }
    }
}

