/*
 * Decompiled with CFR 0.152.
 */
package customplugins;

import customplugins.ExecutionTimeConnectionPluginFactory;
import customplugins.MethodCountConnectionPluginFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SampleApplication {
    private static final String PREFIX = "jdbc:mysql:aws://";
    private static final String CONNECTION_STRING = "jdbc:mysql:aws://" + System.getenv("host");
    private static final String USER = System.getenv("user");
    private static final String PASSWORD = System.getenv("password");
    private static final String QUERY = System.getenv("query");

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("software.aws.rds.jdbc.mysql.Driver");
        Properties properties = new Properties();
        properties.setProperty("user", USER);
        properties.setProperty("password", PASSWORD);
        properties.setProperty("logger", "StandardLogger");
        String methodCountConnectionPluginFactoryClassName = MethodCountConnectionPluginFactory.class.getName();
        String executionMeasurementPluginFactoryClassName = ExecutionTimeConnectionPluginFactory.class.getName();
        properties.setProperty("connectionPluginFactories", String.format("%s,%s", methodCountConnectionPluginFactoryClassName, executionMeasurementPluginFactoryClassName));
        try (Connection conn = DriverManager.getConnection(CONNECTION_STRING, properties);
             Statement statement = conn.createStatement();
             ResultSet result = statement.executeQuery(QUERY);){
            int cols = result.getMetaData().getColumnCount();
            while (result.next()) {
                for (int i = 1; i < cols; ++i) {
                    System.out.println(result.getString(i));
                }
            }
        }
    }
}

