/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class SlidingExpirationCache<K, V> {
    protected final Map<K, CacheItem> cache = new ConcurrentHashMap<K, CacheItem>();
    protected long cleanupIntervalNanos = TimeUnit.MINUTES.toNanos(10L);
    protected final AtomicLong cleanupTimeNanos = new AtomicLong(System.nanoTime() + this.cleanupIntervalNanos);
    protected final ShouldDisposeFunc<V> shouldDisposeFunc;
    protected final ItemDisposalFunc<V> itemDisposalFunc;

    public SlidingExpirationCache() {
        this.shouldDisposeFunc = null;
        this.itemDisposalFunc = null;
    }

    public SlidingExpirationCache(ShouldDisposeFunc<V> shouldDisposeFunc, ItemDisposalFunc<V> itemDisposalFunc) {
        this.shouldDisposeFunc = shouldDisposeFunc;
        this.itemDisposalFunc = itemDisposalFunc;
    }

    public SlidingExpirationCache(ShouldDisposeFunc<V> shouldDisposeFunc, ItemDisposalFunc<V> itemDisposalFunc, long cleanupIntervalNanos) {
        this.shouldDisposeFunc = shouldDisposeFunc;
        this.itemDisposalFunc = itemDisposalFunc;
        this.cleanupIntervalNanos = cleanupIntervalNanos;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long itemExpirationNano) {
        this.cleanUp();
        CacheItem cacheItem = this.cache.computeIfAbsent(key, k -> new CacheItem(mappingFunction.apply((K)k), System.nanoTime() + itemExpirationNano));
        return (V)cacheItem.withExtendExpiration(itemExpirationNano).item;
    }

    public V get(K key, long itemExpirationNano) {
        this.cleanUp();
        CacheItem cacheItem = this.cache.get(key);
        return (V)(cacheItem == null ? null : cacheItem.withExtendExpiration(itemExpirationNano).item);
    }

    public void remove(K key) {
        this.removeAndDispose(key);
        this.cleanUp();
    }

    protected void removeAndDispose(K key) {
        CacheItem cacheItem = this.cache.remove(key);
        if (cacheItem != null && this.itemDisposalFunc != null) {
            this.itemDisposalFunc.dispose(cacheItem.item);
        }
    }

    protected void removeIfExpired(K key) {
        CacheItem cacheItem = this.cache.get(key);
        if (cacheItem == null || cacheItem.shouldCleanup()) {
            this.removeAndDispose(key);
        }
    }

    public void clear() {
        for (K key : this.cache.keySet()) {
            this.removeAndDispose(key);
        }
        this.cache.clear();
    }

    public Map<K, V> getEntries() {
        HashMap<K, Object> entries = new HashMap<K, Object>();
        for (Map.Entry<K, CacheItem> entry : this.cache.entrySet()) {
            entries.put(entry.getKey(), entry.getValue().item);
        }
        return entries;
    }

    public int size() {
        return this.cache.size();
    }

    protected void cleanUp() {
        if (this.cleanupTimeNanos.get() > System.nanoTime()) {
            return;
        }
        this.cleanupTimeNanos.set(System.nanoTime() + this.cleanupIntervalNanos);
        this.cache.forEach((key, value) -> this.removeIfExpired(key));
    }

    public void setCleanupIntervalNanos(long cleanupIntervalNanos) {
        this.cleanupIntervalNanos = cleanupIntervalNanos;
        this.cleanupTimeNanos.set(System.nanoTime() + cleanupIntervalNanos);
    }

    Map<K, CacheItem> getCache() {
        return this.cache;
    }

    class CacheItem {
        private final V item;
        private long expirationTimeNano;

        public CacheItem(V item, long expirationTimeNano) {
            this.item = item;
            this.expirationTimeNano = expirationTimeNano;
        }

        boolean shouldCleanup() {
            if (SlidingExpirationCache.this.shouldDisposeFunc != null) {
                return System.nanoTime() > this.expirationTimeNano && SlidingExpirationCache.this.shouldDisposeFunc.shouldDispose(this.item);
            }
            return System.nanoTime() > this.expirationTimeNano;
        }

        public CacheItem withExtendExpiration(long itemExpirationNano) {
            this.expirationTimeNano = System.nanoTime() + itemExpirationNano;
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheItem other = (CacheItem)obj;
            if (this.item == null) {
                return other.item == null;
            }
            return this.item.equals(other.item);
        }

        public String toString() {
            return "CacheItem [item=" + this.item + ", expirationTime=" + this.expirationTimeNano + "]";
        }
    }

    public static interface ItemDisposalFunc<V> {
        public void dispose(V var1);
    }

    public static interface ShouldDisposeFunc<V> {
        public boolean shouldDispose(V var1);
    }
}

