/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IExecutorServiceInitializer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitor;

public class MonitorThreadContainer {
    private static MonitorThreadContainer singleton = null;
    private static final AtomicInteger CLASS_USAGE_COUNT = new AtomicInteger();
    private final Map<String, IMonitor> monitorMap = new ConcurrentHashMap<String, IMonitor>();
    private final Map<IMonitor, Future<?>> tasksMap = new ConcurrentHashMap();
    private final Queue<IMonitor> availableMonitors = new ConcurrentLinkedDeque<IMonitor>();
    private final ExecutorService threadPool;
    private static final Object LOCK_OBJECT = new Object();

    public static MonitorThreadContainer getInstance() {
        return MonitorThreadContainer.getInstance(Executors::newCachedThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MonitorThreadContainer getInstance(IExecutorServiceInitializer executorServiceInitializer) {
        if (singleton == null) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                singleton = new MonitorThreadContainer(executorServiceInitializer);
            }
            CLASS_USAGE_COUNT.set(0);
        }
        CLASS_USAGE_COUNT.getAndIncrement();
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        if (singleton == null) {
            return;
        }
        if (CLASS_USAGE_COUNT.decrementAndGet() <= 0) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                singleton.releaseResources();
                singleton = null;
            }
        }
    }

    private MonitorThreadContainer(IExecutorServiceInitializer executorServiceInitializer) {
        this.threadPool = executorServiceInitializer.createExecutorService();
    }

    public Map<String, IMonitor> getMonitorMap() {
        return this.monitorMap;
    }

    public Map<IMonitor, Future<?>> getTasksMap() {
        return this.tasksMap;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    String getNode(Set<String> nodeKeys) {
        return this.getNode(nodeKeys, null);
    }

    String getNode(Set<String> nodeKeys, String defaultValue) {
        return nodeKeys.stream().filter(this.monitorMap::containsKey).findAny().orElse(defaultValue);
    }

    IMonitor getMonitor(String node) {
        return this.monitorMap.get(node);
    }

    IMonitor getOrCreateMonitor(Set<String> nodeKeys, Supplier<IMonitor> monitorSupplier) {
        String node = this.getNode(nodeKeys, nodeKeys.iterator().next());
        IMonitor monitor = this.monitorMap.computeIfAbsent(node, k -> {
            if (!this.availableMonitors.isEmpty()) {
                IMonitor availableMonitor = this.availableMonitors.remove();
                if (!availableMonitor.isStopped()) {
                    return availableMonitor;
                }
                this.tasksMap.computeIfPresent(availableMonitor, (key, v) -> {
                    v.cancel(true);
                    return null;
                });
            }
            return (IMonitor)monitorSupplier.get();
        });
        this.populateMonitorMap(nodeKeys, monitor);
        return monitor;
    }

    private void populateMonitorMap(Set<String> nodeKeys, IMonitor monitor) {
        for (String nodeKey : nodeKeys) {
            this.monitorMap.putIfAbsent(nodeKey, monitor);
        }
    }

    void addTask(IMonitor monitor) {
        this.tasksMap.computeIfAbsent(monitor, k -> this.threadPool.submit(monitor));
    }

    public void resetResource(IMonitor monitor) {
        if (monitor == null) {
            return;
        }
        List<IMonitor> monitorList = Collections.singletonList(monitor);
        this.monitorMap.values().removeAll(monitorList);
        this.availableMonitors.add(monitor);
    }

    public void releaseResource(IMonitor monitor) {
        if (monitor == null) {
            return;
        }
        List<IMonitor> monitorList = Collections.singletonList(monitor);
        this.monitorMap.values().removeAll(monitorList);
        this.tasksMap.computeIfPresent(monitor, (k, v) -> {
            v.cancel(true);
            return null;
        });
    }

    private void releaseResources() {
        this.monitorMap.clear();
        this.tasksMap.values().stream().filter(val -> !val.isDone() && !val.isCancelled()).forEach(val -> val.cancel(true));
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }
}

