/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ConnectionUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ITopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ReaderFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ClusterAwareReaderFailoverHandler
implements IReaderFailoverHandler {
    protected static final int DEFAULT_FAILOVER_TIMEOUT = 60000;
    protected static final int DEFAULT_READER_CONNECT_TIMEOUT = 30000;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected Map<String, String> initialConnectionProps;
    protected int maxFailoverTimeoutMs;
    protected int timeoutMs;
    protected boolean enableFailoverStrictReader;
    protected final IConnectionProvider connProvider;
    protected final ITopologyService topologyService;

    public ClusterAwareReaderFailoverHandler(ITopologyService topologyService, IConnectionProvider connProvider, Map<String, String> initialConnectionProps, Log log) {
        this(topologyService, connProvider, initialConnectionProps, 60000, 30000, false, log);
    }

    public ClusterAwareReaderFailoverHandler(ITopologyService topologyService, IConnectionProvider connProvider, Map<String, String> initialConnectionProps, int failoverTimeoutMs, int timeoutMs, boolean enableFailoverStrictReader, Log log) {
        this.topologyService = topologyService;
        this.connProvider = connProvider;
        this.initialConnectionProps = initialConnectionProps;
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.timeoutMs = timeoutMs;
        this.enableFailoverStrictReader = enableFailoverStrictReader;
        if (log != null) {
            this.log = log;
        }
    }

    protected void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public ReaderFailoverResult failover(List<HostInfo> hosts, HostInfo currentHost) throws SQLException {
        if (Util.isNullOrEmpty(hosts)) {
            this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.6", new Object[]{"failover"}));
            return new ReaderFailoverResult(null, -1, false);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<ReaderFailoverResult> future = this.submitInternalFailoverTask(hosts, currentHost, executor);
        return this.getInternalFailoverResult(executor, future);
    }

    private Future<ReaderFailoverResult> submitInternalFailoverTask(List<HostInfo> hosts, HostInfo currentHost, ExecutorService executor) {
        Future<ReaderFailoverResult> future = executor.submit(() -> {
            try {
                while (true) {
                    ReaderFailoverResult result;
                    if ((result = this.failoverInternal(hosts, currentHost)) != null && result.isConnected()) {
                        if (!this.enableFailoverStrictReader) {
                            return result;
                        }
                        HostInfo newHost = (HostInfo)hosts.get(result.getConnectionIndex());
                        List<HostInfo> topology = this.topologyService.getTopology(result.getConnection(), true);
                        for (int i = 1; i < topology.size(); ++i) {
                            if (!topology.get(i).equalHostPortPair(newHost)) continue;
                            return result;
                        }
                        try {
                            result.getConnection().close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (SQLException ex) {
                return new ReaderFailoverResult(null, -1, false, ex);
            }
            catch (Exception ex) {
                return new ReaderFailoverResult(null, -1, false, new SQLException(ex));
            }
        });
        executor.shutdown();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getInternalFailoverResult(ExecutorService executor, Future<ReaderFailoverResult> future) throws SQLException {
        ReaderFailoverResult defaultResult = new ReaderFailoverResult(null, -1, false);
        try {
            ReaderFailoverResult result = future.get(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            ReaderFailoverResult readerFailoverResult = result == null ? defaultResult : result;
            return readerFailoverResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
        }
        catch (ExecutionException e) {
            ReaderFailoverResult readerFailoverResult = defaultResult;
            return readerFailoverResult;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            ReaderFailoverResult readerFailoverResult = defaultResult;
            return readerFailoverResult;
        }
        finally {
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
    }

    protected ReaderFailoverResult failoverInternal(List<HostInfo> hosts, HostInfo currentHost) throws SQLException {
        this.topologyService.addToDownHostList(currentHost);
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostTuple> hostGroup = this.getHostTuplesByPriority(hosts, downHosts);
        return this.getConnectionFromHostGroup(hostGroup);
    }

    public List<HostTuple> getHostTuplesByPriority(List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> hostGroup = new ArrayList<HostTuple>();
        this.addActiveReaders(hostGroup, hosts, downHosts);
        HostInfo writerHost = hosts.get(0);
        if (!(writerHost == null || this.enableFailoverStrictReader && hosts.size() != 1)) {
            hostGroup.add(new HostTuple(writerHost, 0));
        }
        this.addDownHosts(hostGroup, hosts, downHosts);
        return hostGroup;
    }

    private void addActiveReaders(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> activeReaders = new ArrayList<HostTuple>();
        for (int i = 1; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (downHosts.contains(host.getHostPortPair())) continue;
            activeReaders.add(new HostTuple(host, i));
        }
        Collections.shuffle(activeReaders);
        list.addAll(activeReaders);
    }

    private void addDownHosts(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> downHostList = new ArrayList<HostTuple>();
        for (int i = 0; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (!downHosts.contains(host.getHostPortPair())) continue;
            downHostList.add(new HostTuple(host, i));
        }
        Collections.shuffle(downHostList);
        list.addAll(downHostList);
    }

    @Override
    public ReaderFailoverResult getReaderConnection(List<HostInfo> hostList) throws SQLException {
        if (Util.isNullOrEmpty(hostList)) {
            this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.6", new Object[]{"getReaderConnection"}));
            return new ReaderFailoverResult(null, -1, false);
        }
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostTuple> tuples = this.getReaderTuplesByPriority(hostList, downHosts);
        return this.getConnectionFromHostGroup(tuples);
    }

    public List<HostTuple> getReaderTuplesByPriority(List<HostInfo> hostList, Set<String> downHosts) {
        ArrayList<HostTuple> tuples = new ArrayList<HostTuple>();
        this.addActiveReaders(tuples, hostList, downHosts);
        this.addDownReaders(tuples, hostList, downHosts);
        return tuples;
    }

    private void addDownReaders(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> downReaders = new ArrayList<HostTuple>();
        for (int i = 1; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (!downHosts.contains(host.getHostPortPair())) continue;
            downReaders.add(new HostTuple(host, i));
        }
        Collections.shuffle(downReaders);
        list.addAll(downReaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReaderFailoverResult getConnectionFromHostGroup(List<HostTuple> hostGroup) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<ReaderFailoverResult> completionService = new ExecutorCompletionService<ReaderFailoverResult>(executor);
        try {
            for (int i = 0; i < hostGroup.size(); i += 2) {
                ReaderFailoverResult result = this.getResultFromNextTaskBatch(hostGroup, executor, completionService, i);
                if (result.isConnected() || result.getException() != null) {
                    ReaderFailoverResult readerFailoverResult = result;
                    return readerFailoverResult;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
                }
            }
            ReaderFailoverResult readerFailoverResult = new ReaderFailoverResult(null, -1, false);
            return readerFailoverResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ReaderFailoverResult getResultFromNextTaskBatch(List<HostTuple> hostGroup, ExecutorService executor, CompletionService<ReaderFailoverResult> completionService, int i) throws SQLException {
        int numTasks = i + 1 < hostGroup.size() ? 2 : 1;
        completionService.submit(new ConnectionAttemptTask(hostGroup.get(i)));
        if (numTasks == 2) {
            completionService.submit(new ConnectionAttemptTask(hostGroup.get(i + 1)));
        }
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            ReaderFailoverResult result = this.getNextResult(completionService);
            if (result.isConnected()) {
                executor.shutdownNow();
                this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.2", new Object[]{result.getConnectionIndex()}));
                return result;
            }
            if (result.getException() == null) continue;
            executor.shutdownNow();
            return result;
        }
        return new ReaderFailoverResult(null, -1, false);
    }

    private ReaderFailoverResult getNextResult(CompletionService<ReaderFailoverResult> service) throws SQLException {
        ReaderFailoverResult defaultResult = new ReaderFailoverResult(null, -1, false);
        try {
            Future<ReaderFailoverResult> future = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (future == null) {
                return defaultResult;
            }
            ReaderFailoverResult result = future.get();
            return result == null ? defaultResult : result;
        }
        catch (ExecutionException e) {
            return defaultResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
        }
    }

    public static class HostTuple {
        private final HostInfo host;
        private final int index;

        public HostTuple(HostInfo host, int index) {
            this.host = host;
            this.index = index;
        }

        public HostInfo getHost() {
            return this.host;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Objects.hash(this.host, this.index);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            HostTuple other = (HostTuple)obj;
            return other.host != null && this.host.equalHostPortPair(other.host) && this.index == other.index;
        }
    }

    private class ConnectionAttemptTask
    implements Callable<ReaderFailoverResult> {
        private final HostTuple newHostTuple;

        private ConnectionAttemptTask(HostTuple newHostTuple) {
            this.newHostTuple = newHostTuple;
        }

        @Override
        public ReaderFailoverResult call() {
            HostInfo newHost = this.newHostTuple.getHost();
            ClusterAwareReaderFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.3", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
            try {
                HostInfo newHostWithProps = ConnectionUtils.copyWithAdditionalProps(newHost, ClusterAwareReaderFailoverHandler.this.initialConnectionProps);
                ConnectionImpl conn = ClusterAwareReaderFailoverHandler.this.connProvider.connect(newHostWithProps);
                ClusterAwareReaderFailoverHandler.this.topologyService.removeFromDownHostList(newHost);
                ClusterAwareReaderFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.4", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
                return new ReaderFailoverResult(conn, this.newHostTuple.getIndex(), true);
            }
            catch (SQLException e) {
                ClusterAwareReaderFailoverHandler.this.topologyService.addToDownHostList(newHost);
                ClusterAwareReaderFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.5", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
                if (!ConnectionUtils.isNetworkException(e)) {
                    return new ReaderFailoverResult(null, -1, false, e);
                }
                return new ReaderFailoverResult(null, -1, false);
            }
        }
    }
}

