/*
 * Decompiled with CFR 0.152.
 */
package customplugins;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class MethodCountConnectionPlugin
implements IConnectionPlugin {
    private final IConnectionPlugin nextPlugin;
    private final Log logger;
    private final Map<String, Integer> methodCount = new HashMap<String, Integer>();

    public MethodCountConnectionPlugin(IConnectionPlugin nextPlugin, Log logger) {
        this.nextPlugin = nextPlugin;
        this.logger = logger;
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeJdbcMethod, Object[] args) throws Exception {
        this.methodCount.merge(methodName, 1, Integer::sum);
        return this.nextPlugin.execute(methodInvokeOn, methodName, executeJdbcMethod, args);
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.nextPlugin.openInitialConnection(connectionUrl);
    }

    @Override
    public void releaseResources() {
        String leftAlignFormat = "| %-19s | %-10d |\n";
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("** MethodCountConnectionPlugin Summary **\n").append("+---------------------+------------+\n").append("| Method Executed     | Frequency  |\n").append("+---------------------+------------+\n");
        this.methodCount.forEach((key, val) -> logMessage.append(String.format("| %-19s | %-10d |\n", key, val)));
        logMessage.append("+---------------------+------------+\n");
        this.logger.logInfo(logMessage);
        this.methodCount.clear();
        this.nextPlugin.releaseResources();
    }
}

