/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;
import software.amazon.awssdk.utils.Pair;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.LRUCache;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;

public class AWSSecretsManagerPlugin
implements IConnectionPlugin {
    static final String SECRET_ID_PROPERTY = "secretsManagerSecretId";
    static final String REGION_PROPERTY = "secretsManagerRegion";
    private static final String ERROR_MISSING_DEPENDENCY_SECRETS = "[AWSSecretsManagerPlugin] Required dependency 'AWS Java SDK for AWS Secrets Manager' is not on the classpath";
    private static final String ERROR_MISSING_DEPENDENCY_JACKSON = "[AWSSecretsManagerPlugin] Required dependency 'Jackson Databind' is not on the classpath";
    static final String ERROR_GET_SECRETS_FAILED = "[AWSSecretsManagerPlugin] Was not able to either fetch or read the database credentials from AWS Secrets Manager. Ensure the correct secretId and region properties have been provided";
    static final String SQLSTATE_ACCESS_ERROR = "28000";
    static final LRUCache<Pair<String, Region>, Secret> SECRET_CACHE = new LRUCache(100);
    private final IConnectionPlugin nextPlugin;
    private final Log logger;
    private final String secretId;
    private final Region region;
    private final SecretsManagerClient secretsManagerClient;
    private final GetSecretValueRequest getSecretValueRequest;
    private final Pair<String, Region> secretKey;
    private Secret secret;

    public AWSSecretsManagerPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger) throws SQLException {
        this(currentConnectionProvider, propertySet, nextPlugin, logger, null, null);
    }

    AWSSecretsManagerPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger, SecretsManagerClient secretsManagerClient, GetSecretValueRequest getSecretValueRequest) throws SQLException {
        try {
            Class.forName("software.amazon.awssdk.services.secretsmanager.SecretsManagerClient");
        }
        catch (ClassNotFoundException e) {
            logger.logError(ERROR_MISSING_DEPENDENCY_SECRETS);
            throw new SQLException(ERROR_MISSING_DEPENDENCY_SECRETS);
        }
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
        }
        catch (ClassNotFoundException e) {
            logger.logError(ERROR_MISSING_DEPENDENCY_JACKSON);
            throw new SQLException(ERROR_MISSING_DEPENDENCY_JACKSON);
        }
        if (StringUtils.isNullOrEmpty(propertySet.getStringProperty(SECRET_ID_PROPERTY).getValue())) {
            throw new SQLException(String.format("Configuration parameter '%s' is required.", SECRET_ID_PROPERTY));
        }
        if (StringUtils.isNullOrEmpty(propertySet.getStringProperty(REGION_PROPERTY).getValue())) {
            throw new SQLException(String.format("Configuration parameter '%s' is required.", REGION_PROPERTY));
        }
        this.nextPlugin = nextPlugin;
        this.logger = logger;
        this.secretId = propertySet.getStringProperty(SECRET_ID_PROPERTY).getValue();
        this.region = Region.of((String)propertySet.getStringProperty(REGION_PROPERTY).getValue());
        this.secretKey = Pair.of((Object)this.secretId, (Object)this.region);
        if (secretsManagerClient != null && getSecretValueRequest != null) {
            this.secretsManagerClient = secretsManagerClient;
            this.getSecretValueRequest = getSecretValueRequest;
        } else {
            this.secretsManagerClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(this.region)).build();
            this.getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.secretId).build();
        }
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        Properties properties = new Properties();
        properties.putAll(connectionUrl.getOriginalProperties());
        boolean secretWasFetched = this.updateSecret(false);
        try {
            this.applySecretToProperties(properties);
            this.attemptToLogin(properties, connectionUrl);
        }
        catch (SQLException exception) {
            if (this.isLoginUnsuccessful(exception) && !secretWasFetched && (secretWasFetched = this.updateSecret(true))) {
                this.applySecretToProperties(properties);
                this.attemptToLogin(properties, connectionUrl);
                return;
            }
            throw exception;
        }
        catch (Exception exception) {
            this.logger.logError("Unhandled exception:", exception);
            throw new SQLException(exception);
        }
    }

    private boolean isLoginUnsuccessful(SQLException exception) {
        this.logger.logTrace("Login failed. SQLState=" + exception.getSQLState(), exception);
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            String sqlState = "";
            if (throwable instanceof SQLException) {
                sqlState = throwable.getSQLState();
            } else if (throwable instanceof CJException) {
                sqlState = ((CJException)throwable).getSQLState();
            }
            if (!SQLSTATE_ACCESS_ERROR.equals(sqlState)) continue;
            return true;
        }
        return false;
    }

    private void applySecretToProperties(Properties properties) {
        if (this.secret != null) {
            properties.put("user", this.secret.getUsername());
            properties.put("password", this.secret.getPassword());
        }
    }

    private boolean updateSecret(boolean forceReFetch) throws SQLException {
        boolean fetched = false;
        this.secret = (Secret)SECRET_CACHE.get(this.secretKey);
        if (this.secret == null || forceReFetch) {
            try {
                this.secret = this.fetchLatestCredentials();
                if (this.secret != null) {
                    fetched = true;
                    SECRET_CACHE.put(this.secretKey, this.secret);
                }
            }
            catch (JsonProcessingException | SecretsManagerException exception) {
                this.logger.logError(ERROR_GET_SECRETS_FAILED, exception);
                throw new SQLException(ERROR_GET_SECRETS_FAILED, exception);
            }
        }
        return fetched;
    }

    private void attemptToLogin(Properties props, ConnectionUrl connectionUrl) throws SQLException {
        ConnectionUrl newConnectionUrl = ConnectionUrl.getConnectionUrlInstance(connectionUrl.getDatabaseUrl(), props);
        this.nextPlugin.openInitialConnection(newConnectionUrl);
    }

    Secret fetchLatestCredentials() throws SecretsManagerException, JsonProcessingException {
        GetSecretValueResponse valueResponse = this.secretsManagerClient.getSecretValue(this.getSecretValueRequest);
        ObjectMapper mapper = new ObjectMapper();
        return (Secret)mapper.readValue(valueResponse.secretString(), Secret.class);
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        return this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void releaseResources() {
        this.nextPlugin.releaseResources();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Secret {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;

        Secret() {
        }

        Secret(String username, String password) {
            this.username = username;
            this.password = password;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

