/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class Monitor
implements IMonitor {
    static final long DEFAULT_CONNECTION_CHECK_INTERVAL_MILLIS = 100L;
    static final long DEFAULT_CONNECTION_CHECK_TIMEOUT_MILLIS = 3000L;
    private static final int THREAD_SLEEP_WHEN_INACTIVE_MILLIS = 100;
    private static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    private final Queue<MonitorConnectionContext> contexts = new ConcurrentLinkedQueue<MonitorConnectionContext>();
    private final IConnectionProvider connectionProvider;
    private final Log logger;
    private final PropertySet propertySet;
    private final HostInfo hostInfo;
    private Connection monitoringConn = null;
    private long connectionCheckIntervalMillis = 100L;
    private boolean isConnectionCheckIntervalInitialized = false;
    private final AtomicLong contextLastUsedTimestampNano = new AtomicLong();
    private final long monitorDisposalTimeMillis;
    private final IMonitorService monitorService;
    private final AtomicBoolean stopped = new AtomicBoolean(true);

    public Monitor(IConnectionProvider connectionProvider, HostInfo hostInfo, PropertySet propertySet, long monitorDisposalTimeMillis, IMonitorService monitorService, Log logger) {
        this.connectionProvider = connectionProvider;
        this.hostInfo = hostInfo;
        this.propertySet = propertySet;
        this.logger = logger;
        this.monitorDisposalTimeMillis = monitorDisposalTimeMillis;
        this.monitorService = monitorService;
        this.contextLastUsedTimestampNano.set(this.getCurrentTimeNano());
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    @Override
    public void startMonitoring(MonitorConnectionContext context) {
        if (!this.isConnectionCheckIntervalInitialized) {
            this.connectionCheckIntervalMillis = context.getFailureDetectionIntervalMillis();
            this.isConnectionCheckIntervalInitialized = true;
        } else {
            this.connectionCheckIntervalMillis = Math.min(this.connectionCheckIntervalMillis, (long)context.getFailureDetectionIntervalMillis());
        }
        long currentTimeNano = this.getCurrentTimeNano();
        context.setStartMonitorTimeNano(currentTimeNano);
        this.contextLastUsedTimestampNano.set(currentTimeNano);
        this.contexts.add(context);
    }

    @Override
    public void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            this.logger.logWarn(NullArgumentMessage.getMessage("context"));
            return;
        }
        context.invalidate();
        this.contexts.remove(context);
        this.connectionCheckIntervalMillis = this.findShortestIntervalMillis();
        this.isConnectionCheckIntervalInitialized = true;
    }

    @Override
    public synchronized void clearContexts() {
        this.contexts.clear();
        this.connectionCheckIntervalMillis = this.findShortestIntervalMillis();
        this.isConnectionCheckIntervalInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped.set(false);
            while (true) {
                if (!this.contexts.isEmpty()) {
                    long statusCheckStartTimeNano = this.getCurrentTimeNano();
                    this.contextLastUsedTimestampNano.set(statusCheckStartTimeNano);
                    ConnectionStatus status = this.checkConnectionStatus(this.getConnectionCheckTimeoutMillis());
                    for (MonitorConnectionContext monitorContext : this.contexts) {
                        monitorContext.updateConnectionStatus(statusCheckStartTimeNano, statusCheckStartTimeNano + status.elapsedTimeNano, status.isValid);
                    }
                    TimeUnit.MILLISECONDS.sleep(Math.max(0L, this.getConnectionCheckIntervalMillis() - TimeUnit.NANOSECONDS.toMillis(status.elapsedTimeNano)));
                    continue;
                }
                if (this.getCurrentTimeNano() - this.contextLastUsedTimestampNano.get() >= TimeUnit.MILLISECONDS.toNanos(this.monitorDisposalTimeMillis)) {
                    this.monitorService.notifyUnused(this);
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
            this.stopped.set(true);
        }
    }

    ConnectionStatus checkConnectionStatus(long shortestFailureDetectionIntervalMillis) {
        long startNano = this.getCurrentTimeNano();
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                HashMap<String, String> monitoringConnProperties = new HashMap<String, String>();
                String defaultTimeout = Long.toString(shortestFailureDetectionIntervalMillis);
                monitoringConnProperties.put(PropertyKey.connectTimeout.getKeyName(), defaultTimeout);
                monitoringConnProperties.put(PropertyKey.socketTimeout.getKeyName(), defaultTimeout);
                Properties originalProperties = this.propertySet.exposeAsProperties();
                if (originalProperties != null) {
                    originalProperties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), originalProperties.getProperty((String)p)));
                }
                startNano = this.getCurrentTimeNano();
                this.monitoringConn = this.connectionProvider.connect(this.copy(this.hostInfo, monitoringConnProperties));
                return new ConnectionStatus(true, this.getCurrentTimeNano() - startNano);
            }
            startNano = this.getCurrentTimeNano();
            boolean isValid = this.monitoringConn.isValid((int)TimeUnit.MILLISECONDS.toSeconds(shortestFailureDetectionIntervalMillis));
            return new ConnectionStatus(isValid, this.getCurrentTimeNano() - startNano);
        }
        catch (SQLException sqlEx) {
            return new ConnectionStatus(false, this.getCurrentTimeNano() - startNano);
        }
    }

    long getConnectionCheckTimeoutMillis() {
        return this.connectionCheckIntervalMillis == 0L ? 3000L : this.connectionCheckIntervalMillis;
    }

    long getConnectionCheckIntervalMillis() {
        return this.connectionCheckIntervalMillis == 0L ? 100L : this.connectionCheckIntervalMillis;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    private HostInfo copy(HostInfo src, Map<String, String> props) {
        return new HostInfo(null, src.getHost(), src.getPort(), src.getUser(), src.getPassword(), props);
    }

    private long findShortestIntervalMillis() {
        long currentMin = Long.MAX_VALUE;
        for (MonitorConnectionContext context : this.contexts) {
            currentMin = Math.min(currentMin, (long)context.getFailureDetectionIntervalMillis());
        }
        return currentMin == Long.MAX_VALUE ? 100L : currentMin;
    }

    static class ConnectionStatus {
        boolean isValid;
        long elapsedTimeNano;

        ConnectionStatus(boolean isValid, long elapsedTimeNano) {
            this.isValid = isValid;
            this.elapsedTimeNano = elapsedTimeNano;
        }
    }
}

