/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class MonitorConnectionContext {
    private final int failureDetectionIntervalMillis;
    private final int failureDetectionTimeMillis;
    private final int failureDetectionCount;
    private final Set<String> nodeKeys;
    private final Log log;
    private final JdbcConnection connectionToAbort;
    private long startMonitorTimeNano;
    private long invalidNodeStartTimeNano;
    private int failureCount;
    private boolean nodeUnhealthy;
    private AtomicBoolean activeContext = new AtomicBoolean(true);

    public MonitorConnectionContext(JdbcConnection connectionToAbort, Set<String> nodeKeys, Log log, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        this.connectionToAbort = connectionToAbort;
        this.nodeKeys = nodeKeys;
        this.log = log;
        this.failureDetectionTimeMillis = failureDetectionTimeMillis;
        this.failureDetectionIntervalMillis = failureDetectionIntervalMillis;
        this.failureDetectionCount = failureDetectionCount;
    }

    void setStartMonitorTimeNano(long startMonitorTimeNano) {
        this.startMonitorTimeNano = startMonitorTimeNano;
    }

    Set<String> getNodeKeys() {
        return this.nodeKeys;
    }

    public int getFailureDetectionTimeMillis() {
        return this.failureDetectionTimeMillis;
    }

    public int getFailureDetectionIntervalMillis() {
        return this.failureDetectionIntervalMillis;
    }

    public int getFailureDetectionCount() {
        return this.failureDetectionCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    void setInvalidNodeStartTimeNano(long invalidNodeStartTimeNano) {
        this.invalidNodeStartTimeNano = invalidNodeStartTimeNano;
    }

    void resetInvalidNodeStartTime() {
        this.invalidNodeStartTimeNano = 0L;
    }

    boolean isInvalidNodeStartTimeDefined() {
        return this.invalidNodeStartTimeNano > 0L;
    }

    public long getInvalidNodeStartTimeNano() {
        return this.invalidNodeStartTimeNano;
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy;
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy = nodeUnhealthy;
    }

    public boolean isActiveContext() {
        return this.activeContext.get();
    }

    public void invalidate() {
        this.activeContext.set(false);
    }

    synchronized void abortConnection() {
        if (this.connectionToAbort == null || !this.activeContext.get()) {
            return;
        }
        try {
            this.connectionToAbort.abortInternal();
        }
        catch (SQLException sqlEx) {
            this.log.logTrace(String.format("[MonitorConnectionContext] Exception during aborting connection: %s", sqlEx.getMessage()));
        }
    }

    public void updateConnectionStatus(long statusCheckStartNano, long statusCheckEndNano, boolean isValid) {
        if (!this.activeContext.get()) {
            return;
        }
        long totalElapsedTimeNano = statusCheckEndNano - this.startMonitorTimeNano;
        if (totalElapsedTimeNano > TimeUnit.MILLISECONDS.toNanos(this.failureDetectionTimeMillis)) {
            this.setConnectionValid(isValid, statusCheckStartNano, statusCheckEndNano);
        }
    }

    void setConnectionValid(boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationMillis;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (!this.isInvalidNodeStartTimeDefined()) {
                this.setInvalidNodeStartTimeNano(statusCheckStartNano);
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.getInvalidNodeStartTimeNano()) >= TimeUnit.MILLISECONDS.toNanos(maxInvalidNodeDurationMillis = (long)this.getFailureDetectionIntervalMillis() * (long)Math.max(0, this.getFailureDetectionCount()))) {
                this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *dead*.", this.nodeKeys));
                this.setNodeUnhealthy(true);
                this.abortConnection();
                return;
            }
            this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is not *responding* (%d).", this.nodeKeys, this.getFailureCount()));
            return;
        }
        this.setFailureCount(0);
        this.resetInvalidNodeStartTime();
        this.setNodeUnhealthy(false);
        this.log.logTrace(String.format("[MonitorConnectionContext] node '%s' is *alive*.", this.nodeKeys));
    }
}

