/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcPropertySetImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ConnectionProxyLifecycleInterceptor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ConnectionPluginManager;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.LogFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ConnectionProxy
implements ICurrentConnectionProvider,
InvocationHandler {
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    static final String METHOD_EQUALS = "equals";
    private static final String METHOD_HASH_CODE = "hashCode";
    private final JdbcPropertySetImpl connProps = new JdbcPropertySetImpl();
    protected transient Log log = NULL_LOGGER;
    protected Map<String, String> initialConnectionProps;
    protected ConnectionPluginManager pluginManager = null;
    private HostInfo currentHostInfo;
    private JdbcConnection currentConnection;
    private Class<?> currentConnectionClass;

    public ConnectionProxy(ConnectionUrl connectionUrl) throws SQLException {
        this(connectionUrl, null);
    }

    public ConnectionProxy(ConnectionUrl connectionUrl, JdbcConnection connection) throws SQLException {
        this(connectionUrl, connection, ConnectionPluginManager::new);
    }

    ConnectionProxy(ConnectionUrl connectionUrl, JdbcConnection connection, Function<Log, ConnectionPluginManager> connectionPluginManagerInitializer) throws SQLException {
        this.currentHostInfo = connectionUrl.getMainHost();
        this.currentConnection = connection;
        this.currentConnectionClass = connection == null ? null : connection.getClass();
        this.initLogger(connectionUrl);
        this.initSettings(connectionUrl);
        this.initPluginManager(connectionPluginManagerInitializer, connectionUrl);
        this.currentConnection.setConnectionLifecycleInterceptor(new ConnectionProxyLifecycleInterceptor(this.pluginManager));
    }

    public static JdbcConnection autodetectClusterAndCreateProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        boolean pluginsEnabled = Boolean.parseBoolean(connectionUrl.getConnectionArgumentsAsProperties().getProperty(PropertyKey.useConnectionPlugins.getKeyName(), Boolean.toString(true)));
        if (pluginsEnabled) {
            ConnectionProxy connProxy = new ConnectionProxy(connectionUrl);
            return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
        }
        BasicConnectionProvider connectionProvider = new BasicConnectionProvider();
        return connectionProvider.connect(connectionUrl.getMainHost());
    }

    public static JdbcConnection createProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        BasicConnectionProvider connectionProvider = new BasicConnectionProvider();
        ConnectionProxy connProxy = new ConnectionProxy(connectionUrl, connectionProvider.connect(connectionUrl.getMainHost()));
        return (JdbcConnection)Proxy.newProxyInstance(JdbcConnection.class.getClassLoader(), new Class[]{JdbcConnection.class}, (InvocationHandler)connProxy);
    }

    @Override
    public JdbcConnection getCurrentConnection() {
        return this.currentConnection;
    }

    @Override
    public HostInfo getCurrentHostInfo() {
        return this.currentHostInfo;
    }

    @Override
    public void setCurrentConnection(JdbcConnection connection, HostInfo info) {
        try {
            if (this.currentConnection != null && !this.currentConnection.equals(connection) && !this.currentConnection.isClosed()) {
                this.currentConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.currentConnection = connection;
        this.currentConnectionClass = connection == null ? null : connection.getClass();
        this.currentHostInfo = info;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.isDirectExecute(methodName)) {
            return this.executeMethodDirectly(methodName, args);
        }
        JdbcConnection jdbcConnection = this.currentConnection;
        synchronized (jdbcConnection) {
            try {
                Object result = this.pluginManager.execute(this.currentConnectionClass, methodName, () -> method.invoke((Object)this.currentConnection, args), args);
                return this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
            }
            catch (Exception e) {
                Class<?>[] declaredExceptions;
                for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
                    if (!declaredException.isAssignableFrom(e.getClass())) continue;
                    throw e;
                }
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    protected InvocationHandler getNewJdbcInterfaceProxy(Object toProxy) {
        return new JdbcInterfaceProxy(toProxy);
    }

    protected void initLogger(ConnectionUrl connUrl) {
        String loggerClassName = connUrl.getOriginalProperties().get(PropertyKey.logger.getKeyName());
        if (!StringUtils.isNullOrEmpty(loggerClassName)) {
            this.log = LogFactory.getLogger(loggerClassName, "MySQL");
        }
    }

    protected void initSettings(ConnectionUrl connectionUrl) throws SQLException {
        try {
            Properties props = new Properties();
            for (Map.Entry<String, String> entry : connectionUrl.getMainHost().getHostProperties().entrySet()) {
                if (entry.getValue() == null) continue;
                props.put(entry.getKey(), entry.getValue());
            }
            this.connProps.initializeProperties(props);
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, null);
        }
    }

    protected Object proxyIfReturnTypeIsJdbcInterface(Class<?> returnType, Object toProxy) {
        if (toProxy != null && Util.isJdbcInterface(returnType)) {
            Class<?> toProxyClass = toProxy.getClass();
            return Proxy.newProxyInstance(toProxyClass.getClassLoader(), Util.getImplementedInterfaces(toProxyClass), this.getNewJdbcInterfaceProxy(toProxy));
        }
        return toProxy;
    }

    private Object executeMethodDirectly(String methodName, Object[] args) {
        if (METHOD_EQUALS.equals(methodName) && args != null && args.length > 0 && args[0] != null) {
            return args[0].equals(this);
        }
        if (METHOD_HASH_CODE.equals(methodName)) {
            return this.hashCode();
        }
        return null;
    }

    protected void initPluginManager(Function<Log, ConnectionPluginManager> connectionPluginManagerInitializer, ConnectionUrl connectionUrl) throws SQLException {
        if (this.pluginManager == null) {
            this.pluginManager = connectionPluginManagerInitializer.apply(this.log);
            this.pluginManager.init(this, this.connProps);
            if (this.currentConnection == null) {
                this.pluginManager.openInitialConnection(connectionUrl);
            }
        }
    }

    private boolean isDirectExecute(String methodName) {
        return METHOD_EQUALS.equals(methodName) || METHOD_HASH_CODE.equals(methodName);
    }

    class JdbcInterfaceProxy
    implements InvocationHandler {
        private final Object invokeOn;
        private final Class<?> invokeOnClass;

        JdbcInterfaceProxy(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
            this.invokeOnClass = toInvokeOn == null ? null : toInvokeOn.getClass();
        }

        private Object executeMethodDirectly(String methodName, Object[] args) {
            if (ConnectionProxy.METHOD_EQUALS.equals(methodName) && args != null && args.length > 0 && args[0] != null) {
                return args[0].equals(this);
            }
            if (ConnectionProxy.METHOD_HASH_CODE.equals(methodName)) {
                return this.hashCode();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (ConnectionProxy.this.isDirectExecute(methodName)) {
                return this.executeMethodDirectly(methodName, args);
            }
            Object object = this.invokeOn;
            synchronized (object) {
                Object result = ConnectionProxy.this.pluginManager.execute(this.invokeOnClass, methodName, () -> method.invoke(this.invokeOn, args), args);
                return ConnectionProxy.this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
            }
        }
    }
}

