/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ConnectionUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ITopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IWriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ReaderFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.WriterFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ClusterAwareWriterFailoverHandler
implements IWriterFailoverHandler {
    static final int WRITER_CONNECTION_INDEX = 0;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;
    protected Map<String, String> initialConnectionProps;
    protected ITopologyService topologyService;
    protected IConnectionProvider connectionProvider;
    protected IReaderFailoverHandler readerFailoverHandler;

    public ClusterAwareWriterFailoverHandler(ITopologyService topologyService, IConnectionProvider connectionProvider, IReaderFailoverHandler readerFailoverHandler, Map<String, String> initialConnectionProps, Log log) {
        this.topologyService = topologyService;
        this.connectionProvider = connectionProvider;
        this.readerFailoverHandler = readerFailoverHandler;
        this.initialConnectionProps = initialConnectionProps;
        if (log != null) {
            this.log = log;
        }
    }

    public ClusterAwareWriterFailoverHandler(ITopologyService topologyService, IConnectionProvider connectionProvider, IReaderFailoverHandler readerFailoverHandler, Map<String, String> initialConnectionProps, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs, Log log) {
        this(topologyService, connectionProvider, readerFailoverHandler, initialConnectionProps, log);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriterFailoverResult failover(List<HostInfo> currentTopology) throws SQLException {
        if (Util.isNullOrEmpty(currentTopology)) {
            this.log.logError(Messages.getString("ClusterAwareWriterFailoverHandler.7"));
            return new WriterFailoverResult(false, false, null, null, "None");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<WriterFailoverResult> completionService = new ExecutorCompletionService<WriterFailoverResult>(executorService);
        this.submitTasks(currentTopology, executorService, completionService);
        try {
            long startTimeNano = System.nanoTime();
            WriterFailoverResult result = this.getNextResult(executorService, completionService, this.maxFailoverTimeoutMs);
            if (result.isConnected() || result.getException() != null) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            long endTimeNano = System.nanoTime();
            int durationMs = (int)TimeUnit.NANOSECONDS.toMillis(endTimeNano - startTimeNano);
            int remainingTimeMs = this.maxFailoverTimeoutMs - durationMs;
            if (remainingTimeMs > 0 && ((result = this.getNextResult(executorService, completionService, remainingTimeMs)).isConnected() || result.getException() != null)) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "None");
            return writerFailoverResult;
        }
        finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private void submitTasks(List<HostInfo> currentTopology, ExecutorService executorService, CompletionService<WriterFailoverResult> completionService) {
        HostInfo writerHost = currentTopology.get(0);
        this.topologyService.addToDownHostList(writerHost);
        completionService.submit(new ReconnectToWriterHandler(writerHost));
        completionService.submit(new WaitForNewWriterHandler(currentTopology, writerHost));
        executorService.shutdown();
    }

    private WriterFailoverResult getNextResult(ExecutorService executorService, CompletionService<WriterFailoverResult> completionService, int timeoutMs) throws SQLException {
        try {
            Future<WriterFailoverResult> firstCompleted = completionService.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted == null) {
                return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null, "None");
            }
            WriterFailoverResult result = firstCompleted.get();
            if (result.isConnected()) {
                executorService.shutdownNow();
                this.logTaskSuccess(result);
                return result;
            }
            if (result.getException() != null) {
                executorService.shutdownNow();
                return result;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null, "None");
    }

    private void logTaskSuccess(WriterFailoverResult result) {
        List<HostInfo> topology = result.getTopology();
        if (Util.isNullOrEmpty(topology)) {
            String taskName = result.getTaskName() == null ? "None" : result.getTaskName();
            this.log.logError(Messages.getString("ClusterAwareWriterFailoverHandler.5", new Object[]{taskName}));
            return;
        }
        String newWriterHost = topology.get(0).getHostPortPair();
        if (result.isNewHost()) {
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.4", new Object[]{newWriterHost}));
        } else {
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.2", new Object[]{newWriterHost}));
        }
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException(Messages.getString("ClusterAwareWriterFailoverHandler.1"), "70100", e);
    }

    private class WaitForNewWriterHandler
    implements Callable<WriterFailoverResult> {
        private JdbcConnection currentConnection = null;
        private final HostInfo originalWriterHost;
        private List<HostInfo> currentTopology;
        private HostInfo currentReaderHost;
        private JdbcConnection currentReaderConnection;

        public WaitForNewWriterHandler(List<HostInfo> currentTopology, HostInfo currentHost) {
            this.currentTopology = currentTopology;
            this.originalWriterHost = currentHost;
        }

        @Override
        public WriterFailoverResult call() {
            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.9"));
            try {
                boolean success = false;
                while (!success) {
                    this.connectToReader();
                    success = this.refreshTopologyAndConnectToNewWriter();
                    if (success) continue;
                    this.closeReaderConnection();
                }
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(true, true, this.currentTopology, this.currentConnection, "TaskB");
                return writerFailoverResult;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskB");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.15"), ex);
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskB");
                return writerFailoverResult;
            }
            finally {
                this.performFinalCleanup();
                ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.10"));
            }
        }

        private void connectToReader() throws InterruptedException {
            while (true) {
                try {
                    ReaderFailoverResult connResult = ClusterAwareWriterFailoverHandler.this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    if (this.isValidReaderConnection(connResult)) {
                        this.currentReaderConnection = connResult.getConnection();
                        this.currentReaderHost = this.currentTopology.get(connResult.getConnectionIndex());
                        ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.11", new Object[]{connResult.getConnectionIndex(), this.currentReaderHost.getHostPortPair()}));
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.12"));
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }

        private boolean isValidReaderConnection(ReaderFailoverResult result) {
            if (!result.isConnected() || result.getConnection() == null) {
                return false;
            }
            int connIndex = result.getConnectionIndex();
            return connIndex != -1 && connIndex < this.currentTopology.size() && this.currentTopology.get(connIndex) != null;
        }

        private boolean refreshTopologyAndConnectToNewWriter() throws InterruptedException {
            while (true) {
                try {
                    List<HostInfo> topology = ClusterAwareWriterFailoverHandler.this.topologyService.getTopology(this.currentReaderConnection, true);
                    if (!topology.isEmpty()) {
                        if (topology.size() == 1) {
                            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.17", new Object[]{this.currentReaderHost.getHost()}));
                        } else {
                            this.currentTopology = topology;
                            HostInfo writerCandidate = this.currentTopology.get(0);
                            if (!this.isSame(writerCandidate, this.originalWriterHost)) {
                                this.logTopology();
                                if (this.connectToWriter(writerCandidate)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                catch (SQLException | CJCommunicationsException ex) {
                    ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.15"), ex);
                    return false;
                }
                TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.readTopologyIntervalMs);
            }
        }

        private boolean isSame(HostInfo writerCandidate, HostInfo originalWriter) {
            if (writerCandidate == null || originalWriter == null) {
                return false;
            }
            return writerCandidate.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID").equals(originalWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"));
        }

        private boolean connectToWriter(HostInfo writerCandidate) {
            ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.14", new Object[]{writerCandidate.getHostPortPair()}));
            if (this.isSame(writerCandidate, this.currentReaderHost)) {
                ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.18"));
                this.currentConnection = this.currentReaderConnection;
            } else {
                try {
                    HostInfo writerCandidateWithProps = ConnectionUtils.createHostWithProperties(writerCandidate, ClusterAwareWriterFailoverHandler.this.initialConnectionProps);
                    this.currentConnection = ClusterAwareWriterFailoverHandler.this.connectionProvider.connect(writerCandidateWithProps);
                }
                catch (SQLException exception) {
                    ClusterAwareWriterFailoverHandler.this.topologyService.addToDownHostList(writerCandidate);
                    return false;
                }
            }
            ClusterAwareWriterFailoverHandler.this.topologyService.removeFromDownHostList(writerCandidate);
            return true;
        }

        private void closeReaderConnection() {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.currentReaderConnection = null;
            this.currentReaderHost = null;
        }

        private void performFinalCleanup() {
            if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                try {
                    this.currentReaderConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }

        private void logTopology() {
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < this.currentTopology.size(); ++i) {
                HostInfo hostInfo = this.currentTopology.get(i);
                msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
            }
            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.13", new Object[]{msg.toString()}));
        }
    }

    private class ReconnectToWriterHandler
    implements Callable<WriterFailoverResult> {
        private final HostInfo originalWriterHost;

        public ReconnectToWriterHandler(HostInfo originalWriterHost) {
            this.originalWriterHost = originalWriterHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WriterFailoverResult call() {
            ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.6", new Object[]{this.originalWriterHost.getHostPortPair()}));
            Connection conn = null;
            List<HostInfo> latestTopology = null;
            boolean success = false;
            try {
                while (latestTopology == null || Util.isNullOrEmpty(latestTopology)) {
                    block25: {
                        try {
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                            }
                            HostInfo originalHost = ConnectionUtils.createHostWithProperties(this.originalWriterHost, ClusterAwareWriterFailoverHandler.this.initialConnectionProps);
                            conn = ClusterAwareWriterFailoverHandler.this.connectionProvider.connect(originalHost);
                            latestTopology = ClusterAwareWriterFailoverHandler.this.topologyService.getTopology((JdbcConnection)conn, true);
                        }
                        catch (CJCommunicationsException originalHost) {
                        }
                        catch (SQLException exception) {
                            if (ConnectionUtils.isNetworkException(exception)) break block25;
                            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.16"), exception);
                            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA", exception);
                            try {
                                if (conn != null && !success && !conn.isClosed()) {
                                    conn.close();
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.8"));
                            return writerFailoverResult;
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.reconnectWriterIntervalMs);
                }
                success = this.isCurrentHostWriter(latestTopology);
                ClusterAwareWriterFailoverHandler.this.topologyService.removeFromDownHostList(this.originalWriterHost);
                WriterFailoverResult exception = new WriterFailoverResult(success, false, latestTopology, (JdbcConnection)(success ? conn : null), "TaskA");
                return exception;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(success, false, latestTopology, (JdbcConnection)(success ? conn : null), "TaskA");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                ClusterAwareWriterFailoverHandler.this.log.logError(ex);
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA");
                return writerFailoverResult;
            }
            finally {
                try {
                    if (conn != null && !success && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
                ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.8"));
            }
        }

        private boolean isCurrentHostWriter(List<HostInfo> latestTopology) {
            String currentInstanceName = this.originalWriterHost.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            HostInfo latestWriter = latestTopology.get(0);
            if (currentInstanceName == null) {
                return false;
            }
            String latestWriterInstanceName = latestWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            return currentInstanceName.equals(latestWriterInstanceName);
        }
    }
}

