/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import software.betamax.MatchRule;
import software.betamax.message.Request;

public class ComposedMatchRule
implements MatchRule {
    private final ImmutableSet<MatchRule> rules;

    public static MatchRule of(MatchRule ... rules) {
        return new ComposedMatchRule((ImmutableSet<MatchRule>)ImmutableSet.copyOf((Object[])rules));
    }

    public static MatchRule of(Iterable<MatchRule> rules) {
        return new ComposedMatchRule((ImmutableSet<MatchRule>)ImmutableSet.copyOf(rules));
    }

    private ComposedMatchRule(ImmutableSet<MatchRule> rules) {
        this.rules = rules;
    }

    @Override
    public boolean isMatch(final Request a, final Request b) {
        return Iterables.all(this.rules, (Predicate)new Predicate<MatchRule>(){

            public boolean apply(MatchRule rule) {
                return rule.isMatch(a, b);
            }
        });
    }

    public int hashCode() {
        return this.rules.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposedMatchRule that = (ComposedMatchRule)o;
        return this.rules.equals(that.rules);
    }
}

