/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Collection;
import software.betamax.Configuration;
import software.betamax.MatchRule;
import software.betamax.TapeMode;
import software.betamax.internal.RecorderListener;
import software.betamax.tape.Tape;
import software.betamax.tape.TapeLoader;
import software.betamax.tape.yaml.YamlTapeLoader;

public class Recorder {
    private final Configuration configuration;
    private final Collection<RecorderListener> listeners = Lists.newArrayList();
    private Tape tape;

    public Recorder() {
        this(Configuration.builder().build());
    }

    public Recorder(Configuration configuration) {
        this.configuration = configuration;
        configuration.registerListeners(this.listeners);
    }

    public void start(String tapeName, Optional<TapeMode> mode, Optional<MatchRule> matchRule) {
        if (this.tape != null) {
            throw new IllegalStateException("start called when Recorder is already started");
        }
        this.tape = this.getTapeLoader().loadTape(tapeName);
        this.tape.setMode((TapeMode)((Object)mode.or((Object)this.configuration.getDefaultMode())));
        this.tape.setMatchRule((MatchRule)matchRule.or((Object)this.configuration.getDefaultMatchRule()));
        for (RecorderListener listener : this.listeners) {
            listener.onRecorderStart(this.tape);
        }
    }

    public void start(String tapeName, TapeMode mode) {
        this.start(tapeName, mode.toOptional(), (Optional<MatchRule>)Optional.absent());
    }

    public void start(String tapeName) {
        this.start(tapeName, (Optional<TapeMode>)Optional.absent(), (Optional<MatchRule>)Optional.absent());
    }

    public void stop() {
        if (this.tape == null) {
            throw new IllegalStateException("stop called when Recorder is not started");
        }
        for (RecorderListener listener : this.listeners) {
            listener.onRecorderStop();
        }
        this.getTapeLoader().writeTape(this.tape);
        this.tape = null;
    }

    public Tape getTape() {
        return this.tape;
    }

    private TapeLoader<? extends Tape> getTapeLoader() {
        return new YamlTapeLoader(this.configuration.getTapeRoot());
    }
}

