/*
 * Decompiled with CFR 0.152.
 */
package software.betamax;

import com.google.common.base.Optional;

public enum TapeMode {
    UNDEFINED(false, false, false),
    READ_WRITE(true, true, false),
    READ_ONLY(true, false, false),
    READ_SEQUENTIAL(true, false, true),
    WRITE_ONLY(false, true, false),
    WRITE_SEQUENTIAL(false, true, true);

    private final boolean readable;
    private final boolean writable;
    private final boolean sequential;

    private TapeMode(boolean readable, boolean writable, boolean sequential) {
        this.readable = readable;
        this.writable = writable;
        this.sequential = sequential;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean asBoolean() {
        return this.readable || this.writable;
    }

    public Optional<TapeMode> toOptional() {
        if (this.equals((Object)UNDEFINED)) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)this));
    }
}

