/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.io;

import com.google.common.base.Joiner;
import java.io.File;

public final class FileResolver {
    private final File baseDirectory;
    private final String baseDirectoryPath;
    static final Joiner PATH_JOINER = Joiner.on((char)File.separatorChar);

    public FileResolver(File baseDirectory) {
        this.baseDirectory = baseDirectory.getAbsoluteFile();
        this.baseDirectoryPath = baseDirectory.getAbsolutePath();
    }

    public File toFile(String ... path) {
        return new File(this.baseDirectory, PATH_JOINER.join((Object[])path));
    }

    public String toPath(File file) {
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.startsWith(this.baseDirectoryPath)) {
            throw new IllegalArgumentException("file is not in the base directory sub-tree of this FileResolver");
        }
        return absolutePath.substring(this.baseDirectoryPath.length() + 1);
    }
}

