/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.message;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import software.betamax.message.Message;

public abstract class AbstractMessage
implements Message {
    public static final String DEFAULT_CONTENT_TYPE = MediaType.OCTET_STREAM.toString();
    public static final String DEFAULT_CHARSET = Charsets.UTF_8.toString();
    public static final String DEFAULT_ENCODING = "none";

    @Override
    public String getContentType() {
        String header = this.getHeader("Content-Type");
        if (Strings.isNullOrEmpty((String)header)) {
            return DEFAULT_CONTENT_TYPE;
        }
        return MediaType.parse((String)header).withoutParameters().toString();
    }

    @Override
    public String getCharset() {
        String header = this.getHeader("Content-Type");
        if (Strings.isNullOrEmpty((String)header)) {
            return DEFAULT_CHARSET;
        }
        return ((Charset)MediaType.parse((String)header).charset().or((Object)Charsets.UTF_8)).toString();
    }

    @Override
    public String getEncoding() {
        String header = this.getHeader("Content-Encoding");
        return header == null || header.length() == 0 ? DEFAULT_ENCODING : header;
    }

    @Override
    public String getHeader(String name) {
        return this.getHeaders().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] getBodyAsBinary() {
        byte[] byArray;
        InputStream is = this.getBodyAsStream();
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        is.close();
        return byArray;
    }

    @Override
    public final String getBodyAsText() {
        try {
            return new String(this.getBodyAsBinary(), this.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract InputStream getBodyAsStream() throws IOException;
}

