/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.message.filtering;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.betamax.message.Message;

public abstract class HeaderFilteringMessage
implements Message {
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final List<String> NO_PASS_HEADERS = Arrays.asList("Content-Length", "Host", "Proxy-Connection", "Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailer", "Transfer-Encoding", "Upgrade");

    protected abstract Message getDelegate();

    @Override
    public final Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.getDelegate().getHeaders());
        for (String headerName : NO_PASS_HEADERS) {
            headers.remove(headerName);
        }
        return headers;
    }

    @Override
    public final String getHeader(String name) {
        return NO_PASS_HEADERS.contains(name) ? null : this.getDelegate().getHeader(name);
    }

    @Override
    public void addHeader(String name, String value) {
        this.getDelegate().addHeader(name, value);
    }

    @Override
    public boolean hasBody() {
        return this.getDelegate().hasBody();
    }

    @Override
    public String getBodyAsText() {
        return this.getDelegate().getBodyAsText();
    }

    @Override
    public byte[] getBodyAsBinary() {
        return this.getDelegate().getBodyAsBinary();
    }

    @Override
    public String getContentType() {
        return this.getDelegate().getContentType();
    }

    @Override
    public String getCharset() {
        return this.getDelegate().getCharset();
    }

    @Override
    public String getEncoding() {
        return this.getDelegate().getEncoding();
    }
}

