/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.message.tape;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import software.betamax.encoding.AbstractEncoder;
import software.betamax.encoding.DeflateEncoder;
import software.betamax.encoding.GzipEncoder;
import software.betamax.encoding.NoOpEncoder;
import software.betamax.message.AbstractMessage;
import software.betamax.message.Message;

public abstract class RecordedMessage
extends AbstractMessage
implements Message {
    private LinkedHashMap<String, String> headers = new LinkedHashMap();
    private Object body;

    @Override
    public final void addHeader(String name, String value) {
        if (this.headers.get(name) != null) {
            this.headers.put(name, this.headers.get(name) + ", " + value);
        } else {
            this.headers.put(name, value);
        }
    }

    @Override
    public final boolean hasBody() {
        return this.body != null;
    }

    @Override
    protected final InputStream getBodyAsStream() throws UnsupportedEncodingException {
        byte[] bytes = this.hasBody() ? (this.body instanceof String ? ((String)this.body).getBytes(this.getCharset()) : (byte[])this.body) : new byte[]{};
        return new ByteArrayInputStream(bytes);
    }

    private AbstractEncoder getEncoder() {
        String contentEncoding = this.getHeader("Content-Encoding");
        if ("gzip".equals(contentEncoding)) {
            return new GzipEncoder();
        }
        if ("deflate".equals(contentEncoding)) {
            return new DeflateEncoder();
        }
        return new NoOpEncoder();
    }

    public LinkedHashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(LinkedHashMap<String, String> headers) {
        this.headers = headers;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }
}

