/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.proxy.netty;

import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.net.URISyntaxException;
import software.betamax.message.Request;
import software.betamax.proxy.netty.NettyMessageAdapter;

public class NettyRequestAdapter
extends NettyMessageAdapter<HttpRequest>
implements Request {
    public static NettyRequestAdapter wrap(HttpObject message) {
        if (message instanceof HttpRequest) {
            return new NettyRequestAdapter((HttpRequest)message);
        }
        throw new IllegalArgumentException(String.format("%s is not an instance of %s", message.getClass().getName(), HttpRequest.class.getName()));
    }

    NettyRequestAdapter(HttpRequest delegate) {
        super(delegate);
    }

    @Override
    public String getMethod() {
        return ((HttpRequest)this.delegate).getMethod().name();
    }

    @Override
    public URI getUri() {
        try {
            URI uri = new URI(((HttpRequest)this.delegate).getUri());
            if (uri.isAbsolute()) {
                return uri;
            }
            return new URI(String.format("https://%s%s", this.getHeader("Host"), uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid URI in underlying request", e);
        }
    }

    public final HttpRequest getOriginalRequest() {
        return (HttpRequest)this.delegate;
    }
}

