/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.proxy.netty;

import com.google.common.base.Predicate;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;

public class PredicatedHttpFilters
extends HttpFiltersAdapter {
    private final HttpFilters delegate;
    private final Predicate<HttpRequest> predicate;

    public static Predicate<HttpRequest> httpMethodPredicate(final HttpMethod method) {
        return new Predicate<HttpRequest>(){

            public boolean apply(HttpRequest input) {
                return method.equals((Object)input.getMethod());
            }
        };
    }

    public PredicatedHttpFilters(HttpFilters delegate, Predicate<HttpRequest> predicate, HttpRequest originalRequest) {
        super(originalRequest);
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (this.predicate.apply((Object)this.originalRequest)) {
            return this.delegate.clientToProxyRequest(httpObject);
        }
        return null;
    }

    public HttpResponse proxyToServerRequest(HttpObject httpObject) {
        if (this.predicate.apply((Object)this.originalRequest)) {
            return this.delegate.proxyToServerRequest(httpObject);
        }
        return null;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (this.predicate.apply((Object)this.originalRequest)) {
            return this.delegate.serverToProxyResponse(httpObject);
        }
        return httpObject;
    }

    public HttpObject proxyToClientResponse(HttpObject httpObject) {
        if (this.predicate.apply((Object)this.originalRequest)) {
            return this.delegate.proxyToClientResponse(httpObject);
        }
        return httpObject;
    }
}

