/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx;

import jakarta.annotation.Nonnull;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import software.coley.bentofx.building.ControlsBuilding;
import software.coley.bentofx.building.DockBuilding;
import software.coley.bentofx.building.PlaceholderBuilding;
import software.coley.bentofx.building.StageBuilding;
import software.coley.bentofx.event.DockEvent;
import software.coley.bentofx.event.EventBus;
import software.coley.bentofx.layout.container.DockContainerRootBranch;
import software.coley.bentofx.search.SearchHandler;

public class Bento {
    private final ObservableList<DockContainerRootBranch> rootContainers = FXCollections.observableArrayList();
    private final ObservableList<DockContainerRootBranch> rootContainersView = FXCollections.unmodifiableObservableList(this.rootContainers);
    private final EventBus eventBus = this.newEventBus();
    private final SearchHandler searchHandler = this.newSearchHandler();
    private final StageBuilding stageBuilding = this.newStageBuilding();
    private final ControlsBuilding controlsBuilding = this.newControlsBuilding();
    private final DockBuilding dockBuilding = this.newDockBuilding();
    private final PlaceholderBuilding placeholderBuilding = this.newPlaceholderBuilding();

    @Nonnull
    protected EventBus newEventBus() {
        return new EventBus();
    }

    @Nonnull
    protected SearchHandler newSearchHandler() {
        return new SearchHandler(this);
    }

    @Nonnull
    protected StageBuilding newStageBuilding() {
        return new StageBuilding(this);
    }

    @Nonnull
    protected ControlsBuilding newControlsBuilding() {
        return new ControlsBuilding();
    }

    @Nonnull
    protected DockBuilding newDockBuilding() {
        return new DockBuilding(this);
    }

    @Nonnull
    protected PlaceholderBuilding newPlaceholderBuilding() {
        return new PlaceholderBuilding();
    }

    @Nonnull
    public EventBus events() {
        return this.eventBus;
    }

    @Nonnull
    public SearchHandler search() {
        return this.searchHandler;
    }

    @Nonnull
    public StageBuilding stageBuilding() {
        return this.stageBuilding;
    }

    @Nonnull
    public ControlsBuilding controlsBuilding() {
        return this.controlsBuilding;
    }

    @Nonnull
    public DockBuilding dockBuilding() {
        return this.dockBuilding;
    }

    @Nonnull
    public PlaceholderBuilding placeholderBuilding() {
        return this.placeholderBuilding;
    }

    @Nonnull
    public ObservableList<DockContainerRootBranch> getRootContainers() {
        return this.rootContainersView;
    }

    public boolean registerRoot(@Nonnull DockContainerRootBranch container) {
        if (!this.rootContainers.contains((Object)container)) {
            this.rootContainers.add((Object)container);
            this.eventBus.fire(new DockEvent.RootContainerAdded(container));
            return true;
        }
        return false;
    }

    public boolean unregisterRoot(@Nonnull DockContainerRootBranch container) {
        if (this.rootContainers.remove((Object)container)) {
            this.eventBus.fire(new DockEvent.RootContainerRemoved(container));
            return true;
        }
        return false;
    }
}

