/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.building;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import software.coley.bentofx.building.CanvasFactory;
import software.coley.bentofx.building.ContentWrapperFactory;
import software.coley.bentofx.building.HeaderFactory;
import software.coley.bentofx.building.HeaderPaneFactory;
import software.coley.bentofx.building.HeadersFactory;
import software.coley.bentofx.control.ContentWrapper;
import software.coley.bentofx.control.Header;
import software.coley.bentofx.control.HeaderPane;
import software.coley.bentofx.control.Headers;
import software.coley.bentofx.control.canvas.PixelCanvas;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerLeaf;

public class ControlsBuilding
implements HeaderPaneFactory,
HeadersFactory,
HeaderFactory,
ContentWrapperFactory,
CanvasFactory {
    private static final HeaderPaneFactory DEFAULT_HEADER_PANE_FACTORY = HeaderPane::new;
    private static final HeadersFactory DEFAULT_HEADERS_FACTORY = Headers::new;
    private static final HeaderFactory DEFAULT_HEADER_FACTORY = (dockable, parentPane) -> new Header(dockable, parentPane).withDragDrop();
    private static final ContentWrapperFactory DEFAULT_CONTENT_WRAPPER_FACTORY = ContentWrapper::new;
    private static final CanvasFactory DEFAULT_CANVAS_FACTORY = parentPane -> new PixelCanvas();
    private HeaderPaneFactory headerPaneFactory = DEFAULT_HEADER_PANE_FACTORY;
    private HeadersFactory headersFactory = DEFAULT_HEADERS_FACTORY;
    private HeaderFactory headerFactory = DEFAULT_HEADER_FACTORY;
    private ContentWrapperFactory contentWrapperFactory = DEFAULT_CONTENT_WRAPPER_FACTORY;
    private CanvasFactory canvasFactory = DEFAULT_CANVAS_FACTORY;

    @Nonnull
    public HeaderPaneFactory getHeaderPaneFactory() {
        return this.headerPaneFactory;
    }

    public void setHeaderPaneFactory(@Nullable HeaderPaneFactory headerPaneFactory) {
        if (headerPaneFactory == null) {
            headerPaneFactory = DEFAULT_HEADER_PANE_FACTORY;
        }
        this.headerPaneFactory = headerPaneFactory;
    }

    @Nonnull
    public HeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    public void setHeadersFactory(@Nullable HeadersFactory headersFactory) {
        if (headersFactory == null) {
            headersFactory = DEFAULT_HEADERS_FACTORY;
        }
        this.headersFactory = headersFactory;
    }

    @Nonnull
    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void setHeaderFactory(@Nullable HeaderFactory headerFactory) {
        if (headerFactory == null) {
            headerFactory = DEFAULT_HEADER_FACTORY;
        }
        this.headerFactory = headerFactory;
    }

    @Nonnull
    public ContentWrapperFactory getContentWrapperFactory() {
        return this.contentWrapperFactory;
    }

    public void setContentWrapperFactory(@Nullable ContentWrapperFactory contentWrapperFactory) {
        if (contentWrapperFactory == null) {
            contentWrapperFactory = DEFAULT_CONTENT_WRAPPER_FACTORY;
        }
        this.contentWrapperFactory = contentWrapperFactory;
    }

    @Nonnull
    public CanvasFactory getCanvasFactory() {
        return this.canvasFactory;
    }

    public void setCanvasFactory(@Nullable CanvasFactory canvasFactory) {
        if (canvasFactory == null) {
            canvasFactory = DEFAULT_CANVAS_FACTORY;
        }
        this.canvasFactory = canvasFactory;
    }

    @Override
    @Nonnull
    public HeaderPane newHeaderPane(@Nonnull DockContainerLeaf container) {
        return this.headerPaneFactory.newHeaderPane(container);
    }

    @Override
    @Nonnull
    public Headers newHeaders(@Nonnull DockContainerLeaf container, @Nonnull Orientation orientation, @Nonnull Side side) {
        return this.headersFactory.newHeaders(container, orientation, side);
    }

    @Override
    @Nonnull
    public Header newHeader(@Nonnull Dockable dockable, @Nonnull HeaderPane parentPane) {
        return this.headerFactory.newHeader(dockable, parentPane);
    }

    @Override
    @Nonnull
    public ContentWrapper newContentWrapper(@Nonnull DockContainerLeaf container) {
        return this.contentWrapperFactory.newContentWrapper(container);
    }

    @Override
    @Nonnull
    public PixelCanvas newCanvas(@Nonnull DockContainerLeaf container) {
        return this.canvasFactory.newCanvas(container);
    }
}

