/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.building;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import software.coley.bentofx.Bento;
import software.coley.bentofx.building.DockBuilding;
import software.coley.bentofx.building.SceneFactory;
import software.coley.bentofx.building.StageFactory;
import software.coley.bentofx.control.DragDropStage;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.DockContainer;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.layout.container.DockContainerRootBranch;

public class StageBuilding {
    private static final StageFactory DEFAULT_STAGE_FACTORY = sourceStage -> new DragDropStage(true);
    private static final SceneFactory DEFAULT_SCENE_FACTORY = (sourceScene, content, width, height) -> new Scene((Parent)content, width, height);
    private final Bento bento;
    private StageFactory stageFactory = DEFAULT_STAGE_FACTORY;
    private SceneFactory sceneFactory = DEFAULT_SCENE_FACTORY;

    public StageBuilding(@Nonnull Bento bento) {
        this.bento = bento;
    }

    @Nonnull
    public DragDropStage newStageForDockable(@Nonnull Scene sourceScene, @Nonnull DockContainer source, @Nonnull Dockable dockable) {
        Region sourceRegion = source.asRegion();
        double width = sourceRegion.getWidth();
        double height = sourceRegion.getHeight();
        return this.newStageForDockable(sourceScene, dockable, width, height);
    }

    @Nonnull
    public DragDropStage newStageForDockable(@Nullable Scene sourceScene, @Nonnull Dockable dockable, double width, double height) {
        DockBuilding builder = this.bento.dockBuilding();
        DockContainerRootBranch root = builder.root();
        DockContainerLeaf leaf = builder.leaf();
        root.addContainer(leaf);
        leaf.addDockable(dockable);
        Region region = root.asRegion();
        Stage sourceStage = sourceScene == null ? null : (Stage)sourceScene.getWindow();
        DragDropStage stage = this.stageFactory.newStage(sourceStage);
        Scene scene = this.sceneFactory.newScene(sourceScene, region, width, height);
        stage.setScene(scene);
        if (sourceScene != null) {
            scene.setUserAgentStylesheet(sourceScene.getUserAgentStylesheet());
            scene.getStylesheets().addAll((Collection)sourceScene.getStylesheets());
            stage.initOwner((Window)sourceStage);
            stage.setMinWidth(150.0);
            stage.setMinHeight(100.0);
            if (sourceStage != null) {
                stage.getIcons().addAll((Collection)sourceStage.getIcons());
            }
        }
        return stage;
    }

    public void setStageFactory(@Nullable StageFactory factory) {
        if (factory == null) {
            factory = DEFAULT_STAGE_FACTORY;
        }
        this.stageFactory = factory;
    }

    public void setSceneFactory(@Nullable SceneFactory factory) {
        if (factory == null) {
            factory = DEFAULT_SCENE_FACTORY;
        }
        this.sceneFactory = factory;
    }
}

