/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import software.coley.bentofx.control.canvas.ArgbSource;

public class ArgbBufferedImageSource
implements ArgbSource {
    private final BufferedImage image;
    private int[] fullArgbCache;
    private int hash;

    public ArgbBufferedImageSource(@Nonnull BufferedImage image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getArgb(int x, int y) {
        try {
            return this.image.getRGB(x, y);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public int[] getArgb(int x, int y, int width, int height) {
        try {
            return this.image.getRGB(x, y, width, height, null, 0, width);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    @Nonnull
    public int[] getArgb() {
        if (this.fullArgbCache == null) {
            this.fullArgbCache = ArgbSource.super.getArgb();
        }
        return this.fullArgbCache;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.getArgb());
        }
        return this.hash;
    }
}

