/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import software.coley.bentofx.control.canvas.ArgbSource;

public class ArgbImageSource
implements ArgbSource {
    private final Image image;
    private int[] fullArgbCache;
    private int hash;

    public ArgbImageSource(@Nonnull Image image) {
        this.image = image;
    }

    @Override
    public int getWidth() {
        return (int)this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return (int)this.image.getHeight();
    }

    @Override
    public int getArgb(int x, int y) {
        try {
            return this.image.getPixelReader().getArgb(x, y);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public int[] getArgb(int x, int y, int width, int height) {
        try {
            IntBuffer buffer = IntBuffer.allocate(width * height);
            this.image.getPixelReader().getPixels(x, y, width, height, PixelFormat.getIntArgbInstance(), (Buffer)buffer, width);
            return buffer.array();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    @Nonnull
    public int[] getArgb() {
        if (this.fullArgbCache == null) {
            this.fullArgbCache = ArgbSource.super.getArgb();
        }
        return this.fullArgbCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgbImageSource)) {
            return false;
        }
        ArgbImageSource that = (ArgbImageSource)o;
        if (!this.image.equals(that.image)) {
            return false;
        }
        return Arrays.equals(this.fullArgbCache, that.fullArgbCache);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.getArgb());
        }
        return this.hash;
    }
}

