/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import software.coley.bentofx.control.canvas.ArgbSource;
import software.coley.bentofx.control.canvas.PixelPainter;
import software.coley.bentofx.control.canvas.PixelPainterIntArgb;
import software.coley.bentofx.control.canvas.PixelPainterIntArgbPre;

public class PixelCanvas
extends Region {
    private static final int OP_FILL_RECT = 100;
    private static final int OP_FILL_IMG = 101;
    private static final int OP_DRAW_RECT = 200;
    private static final int OP_DRAW_LINE_H = 201;
    private static final int OP_DRAW_LINE_V = 202;
    private static final int OP_DRAW_PX = 203;
    private final PixelPainter<?> pixelPainter;
    private final ImageView view = new ImageView();
    private WritableImage image;
    private int lastDrawHash;
    private int currentDrawHash;

    public PixelCanvas(@Nonnull PixelPainter<?> pixelPainter) {
        this.pixelPainter = pixelPainter;
        this.getChildren().add((Object)this.view);
        this.view.fitWidthProperty().bind((ObservableValue)this.widthProperty());
        this.view.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        this.widthProperty().addListener((ob, old, cur) -> this.markDirty());
        this.heightProperty().addListener((ob, old, cur) -> this.markDirty());
    }

    public PixelCanvas() {
        this(new PixelPainterIntArgbPre());
    }

    public PixelCanvas(@Nonnull PixelPainter<?> pixelPainter, int width, int height) {
        this.pixelPainter = pixelPainter;
        this.getChildren().add((Object)this.view);
        this.setMinSize(width, height);
        this.setMaxSize(width, height);
        this.setPrefSize(width, height);
        this.view.setFitWidth((double)width);
        this.view.setFitHeight((double)height);
        this.reallocate();
    }

    public PixelCanvas(int width, int height) {
        this(new PixelPainterIntArgb(), width, height);
    }

    public void commit() {
        if (this.lastDrawHash == this.currentDrawHash) {
            return;
        }
        this.lastDrawHash = this.currentDrawHash;
        this.checkDirty();
        this.pixelPainter.commit(this.image.getPixelWriter());
        this.view.setImage((Image)this.image);
    }

    public void fillBorderedRect(double x, double y, double width, double height, int borderSize, int color, int borderColor) {
        this.fillRect(x + (double)borderSize, y + (double)borderSize, width - (double)(borderSize * 2), height - (double)(borderSize * 2), color);
        this.drawRect(x, y, width, height, (double)borderSize, borderColor);
    }

    public void fillRect(double x, double y, double width, double height, int color) {
        this.fillRect((int)x, (int)y, (int)width, (int)height, color);
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        this.updateDrawHash(PixelCanvas.hash(100, x, y, width, height));
        this.pixelPainter.fillRect(x, y, width, height, color);
    }

    public void drawRect(double x, double y, double width, double height, double borderSize, int color) {
        this.drawRect((int)x, (int)y, (int)width, (int)height, (int)borderSize, color);
    }

    public void drawRect(int x, int y, int width, int height, int borderSize, int color) {
        this.updateDrawHash(PixelCanvas.hash(200, x, y, width, height, borderSize, color));
        this.pixelPainter.drawRect(x, y, width, height, borderSize, color);
    }

    public void drawHorizontalLine(double x, double y, double lineLength, double lineWidth, int color) {
        this.drawHorizontalLine((int)x, (int)y, (int)lineLength, (int)lineWidth, color);
    }

    public void drawHorizontalLine(int x, int y, int lineLength, int lineWidth, int color) {
        this.updateDrawHash(PixelCanvas.hash(201, x, y, lineLength, lineWidth, color));
        this.pixelPainter.drawHorizontalLine(x, y, lineLength, lineWidth, color);
    }

    public void drawVerticalLine(double x, double y, double lineLength, double lineWidth, int color) {
        this.drawVerticalLine((int)x, (int)y, (int)lineLength, (int)lineWidth, color);
    }

    public void drawVerticalLine(int x, int y, int lineLength, int lineWidth, int color) {
        this.updateDrawHash(PixelCanvas.hash(202, x, y, lineLength, lineWidth, color));
        this.pixelPainter.drawVerticalLine(x, y, lineLength, lineWidth, color);
    }

    public void drawImage(int x, int y, @Nonnull ArgbSource image) {
        this.updateDrawHash(PixelCanvas.hash(101, x, y, image.hashCode()));
        this.pixelPainter.drawImage(x, y, image);
    }

    public void drawImage(int x, int y, int sx, int sy, int sw, int sh, @Nonnull ArgbSource image) {
        this.updateDrawHash(PixelCanvas.hash(101, x, y, sx, sy, sw, sh, image.hashCode()));
        this.pixelPainter.drawImage(x, y, sx, sy, sw, sh, image);
    }

    public void setColor(int x, int y, int color) {
        this.updateDrawHash(PixelCanvas.hash(203, x, y, color));
        this.pixelPainter.setColor(x, y, color);
    }

    public void clear() {
        this.currentDrawHash = 0;
        this.checkDirty();
        this.pixelPainter.clear();
    }

    protected void updateDrawHash(int hash) {
        this.currentDrawHash = this.currentDrawHash == 0 ? hash : this.currentDrawHash * 31 + hash;
        this.checkDirty();
    }

    protected static int hash(int ... values) {
        int hash = values[0];
        for (int i = 1; i < values.length; ++i) {
            hash = 31 * hash + values[i];
        }
        return hash;
    }

    public boolean isDirty() {
        return this.image == null;
    }

    public void markDirty() {
        this.image = null;
        this.currentDrawHash = ~this.lastDrawHash;
    }

    public void checkDirty() {
        if (this.isDirty()) {
            this.reallocate();
        }
    }

    protected void reallocate() {
        int imageHeight;
        int imageWidth = (int)Math.max(1.0, this.view.getFitWidth());
        if (this.pixelPainter.initialize(imageWidth, imageHeight = (int)Math.max(1.0, this.view.getFitHeight())) || this.image == null) {
            this.image = this.newImage(imageWidth, imageHeight);
        }
    }

    @Nonnull
    protected WritableImage newImage(int width, int height) {
        return new WritableImage(width, height);
    }
}

