/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.Buffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import software.coley.bentofx.control.canvas.ArgbSource;

public interface PixelPainter<B extends Buffer> {
    public boolean initialize(int var1, int var2);

    public void release();

    public void commit(@Nonnull PixelWriter var1);

    default public void fillBorderedRect(double x, double y, double width, double height, int borderSize, int color, int borderColor) {
        this.fillRect(x + (double)borderSize, y + (double)borderSize, width - (double)(borderSize * 2), height - (double)(borderSize * 2), color);
        this.drawRect(x, y, width, height, (double)borderSize, borderColor);
    }

    default public void fillRect(double x, double y, double width, double height, int color) {
        this.fillRect((int)x, (int)y, (int)width, (int)height, color);
    }

    public void fillRect(int var1, int var2, int var3, int var4, int var5);

    default public void drawRect(double x, double y, double width, double height, double borderSize, int color) {
        this.drawRect((int)x, (int)y, (int)width, (int)height, (int)borderSize, color);
    }

    default public void drawRect(int x, int y, int width, int height, int borderSize, int color) {
        this.fillRect(x, y, width, borderSize, color);
        this.fillRect(x, y + height - borderSize, width, borderSize, color);
        this.fillRect(x, y + borderSize, borderSize, height - borderSize, color);
        this.fillRect(x + width - borderSize, y + borderSize, borderSize, height - borderSize, color);
    }

    default public void drawHorizontalLine(double x, double y, double lineLength, double lineWidth, int color) {
        this.drawHorizontalLine((int)x, (int)y, (int)lineLength, (int)lineWidth, color);
    }

    default public void drawHorizontalLine(int x, int y, int lineLength, int lineWidth, int color) {
        this.fillRect(x, y - Math.max(1, lineWidth / 2), lineLength, lineWidth, color);
    }

    default public void drawVerticalLine(double x, double y, double lineLength, double lineWidth, int color) {
        this.drawVerticalLine((int)x, (int)y, (int)lineLength, (int)lineWidth, color);
    }

    default public void drawVerticalLine(int x, int y, int lineLength, int lineWidth, int color) {
        this.fillRect(x - Math.max(1, lineWidth / 2), y, lineWidth, lineLength, color);
    }

    public void drawImage(int var1, int var2, @Nonnull ArgbSource var3);

    public void drawImage(int var1, int var2, int var3, int var4, int var5, int var6, @Nonnull ArgbSource var7);

    public void setColor(int var1, int var2, int var3);

    public void clear();

    @Nonnull
    public B getBuffer();

    @Nonnull
    public PixelFormat<B> getPixelFormat();
}

