/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import software.coley.bentofx.control.canvas.ArgbSource;
import software.coley.bentofx.control.canvas.PixelPainter;
import software.coley.bentofx.control.canvas.PixelPainterUtils;

public class PixelPainterByteBgra
implements PixelPainter<ByteBuffer> {
    protected static final int DATA_SIZE = 4;
    protected ByteBuffer drawBuffer = PixelPainterUtils.EMPTY_BUFFER_B;
    protected int imageWidth;
    protected int imageHeight;

    @Override
    public boolean initialize(int width, int height) {
        if (this.imageWidth != width || this.imageHeight != height) {
            this.imageWidth = width;
            this.imageHeight = height;
            int drawBufferCapacity = this.drawBufferCapacity();
            if (drawBufferCapacity > this.drawBuffer.limit()) {
                this.drawBuffer = ByteBuffer.wrap(new byte[drawBufferCapacity]);
                return true;
            }
        }
        this.clear();
        return false;
    }

    @Override
    public void release() {
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.drawBuffer = PixelPainterUtils.EMPTY_BUFFER_B;
    }

    @Override
    public void commit(@Nonnull PixelWriter pixelWriter) {
        pixelWriter.setPixels(0, 0, this.imageWidth, this.imageHeight, this.getPixelFormat(), (Buffer)this.drawBuffer, this.imageWidth * 4);
    }

    @Override
    public void fillRect(int x, int y, int width, int height, int color) {
        byte alpha = (byte)(color >> 24 & 0xFF);
        byte red = (byte)(color >> 16 & 0xFF);
        byte green = (byte)(color >> 8 & 0xFF);
        byte blue = (byte)(color & 0xFF);
        int yBound = Math.min(y + height, this.imageHeight);
        int xBound = Math.min(x + width, this.imageWidth);
        ByteBuffer drawBuffer = this.drawBuffer;
        int capacity = this.drawBufferCapacity();
        for (int ly = y; ly < yBound; ++ly) {
            int yOffset = ly * this.imageWidth;
            for (int lx = x; lx < xBound; ++lx) {
                int index = (yOffset + lx) * 4;
                if (index >= capacity) continue;
                drawBuffer.put(index, blue);
                drawBuffer.put(index + 1, green);
                drawBuffer.put(index + 2, red);
                drawBuffer.put(index + 3, alpha);
            }
        }
    }

    @Override
    public void drawImage(int x, int y, @Nonnull ArgbSource source) {
        int sourceHeight;
        int sourceWidth = source.getWidth();
        int[] argb = source.getArgb(0, 0, sourceWidth, sourceHeight = source.getHeight());
        if (argb == null) {
            return;
        }
        int yBound = Math.min(y + sourceHeight, this.imageHeight);
        int xBound = Math.min(x + sourceWidth, this.imageWidth);
        for (int ly = y; ly < yBound; ++ly) {
            int yOffsetSource = (ly - y) * sourceWidth;
            for (int lx = x; lx < xBound; ++lx) {
                int sourceIndex = yOffsetSource + (lx - x);
                if (sourceIndex >= argb.length) continue;
                this.setColor(lx, ly, argb[sourceIndex]);
            }
        }
    }

    @Override
    public void drawImage(int x, int y, int sx, int sy, int sw, int sh, @Nonnull ArgbSource source) {
        int[] argb = source.getArgb(sx, sy, sw, sh);
        if (argb == null) {
            return;
        }
        int yBound = Math.min(y + sh, this.imageHeight);
        int xBound = Math.min(x + sw, this.imageWidth);
        for (int ly = y; ly < yBound; ++ly) {
            int yOffsetSource = (ly - y) * sw;
            for (int lx = x; lx < xBound; ++lx) {
                int sourceIndex = yOffsetSource + (lx - x);
                if (sourceIndex >= argb.length) continue;
                this.setColor(lx, ly, argb[sourceIndex]);
            }
        }
    }

    @Override
    public void setColor(int x, int y, int color) {
        int i = (y * this.imageWidth + x) * 4;
        if (i >= 0 && i < this.drawBufferCapacity()) {
            byte alpha = (byte)(color >> 24 & 0xFF);
            byte red = (byte)(color >> 16 & 0xFF);
            byte green = (byte)(color >> 8 & 0xFF);
            byte blue = (byte)(color & 0xFF);
            this.drawBuffer.put(i, blue);
            this.drawBuffer.put(i + 1, green);
            this.drawBuffer.put(i + 2, red);
            this.drawBuffer.put(i + 3, alpha);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.drawBuffer.array(), 0, this.drawBufferCapacity(), (byte)0);
    }

    @Override
    @Nonnull
    public ByteBuffer getBuffer() {
        return this.drawBuffer;
    }

    @Override
    @Nonnull
    public PixelFormat<ByteBuffer> getPixelFormat() {
        return PixelFormat.getByteBgraInstance();
    }

    protected int drawBufferCapacity() {
        return this.imageWidth * this.imageHeight * 4;
    }
}

