/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import javafx.scene.image.PixelFormat;
import software.coley.bentofx.control.canvas.PixelPainterByteBgra;

public class PixelPainterByteBgraPre
extends PixelPainterByteBgra {
    @Override
    public void fillRect(int x, int y, int width, int height, int color) {
        int blue;
        int green;
        int red;
        int alpha = color >>> 24;
        if (alpha > 0) {
            red = color >> 16 & 0xFF;
            green = color >> 8 & 0xFF;
            blue = color & 0xFF;
            if (alpha < 255) {
                red = (red * alpha + 127) / 255;
                green = (green * alpha + 127) / 255;
                blue = (blue * alpha + 127) / 255;
            }
        } else {
            blue = 0;
            green = 0;
            red = 0;
        }
        int yBound = Math.min(y + height, this.imageHeight);
        int xBound = Math.min(x + width, this.imageWidth);
        ByteBuffer drawBuffer = this.drawBuffer;
        int capacity = this.drawBufferCapacity();
        for (int ly = y; ly < yBound; ++ly) {
            int yOffset = ly * this.imageWidth;
            for (int lx = x; lx < xBound; ++lx) {
                int index = (yOffset + lx) * 4;
                if (index >= capacity) continue;
                drawBuffer.put(index, (byte)blue);
                drawBuffer.put(index + 1, (byte)green);
                drawBuffer.put(index + 2, (byte)red);
                drawBuffer.put(index + 3, (byte)alpha);
            }
        }
    }

    @Override
    public void setColor(int x, int y, int color) {
        int i = (y * this.imageWidth + x) * 4;
        if (i >= 0 && i < this.drawBufferCapacity()) {
            int blue;
            int green;
            int red;
            int alpha = color >>> 24;
            if (alpha > 0) {
                red = color >> 16 & 0xFF;
                green = color >> 8 & 0xFF;
                blue = color & 0xFF;
                if (alpha < 255) {
                    red = (red * alpha + 127) / 255;
                    green = (green * alpha + 127) / 255;
                    blue = (blue * alpha + 127) / 255;
                }
            } else {
                blue = 0;
                green = 0;
                red = 0;
            }
            this.drawBuffer.put(i, (byte)blue);
            this.drawBuffer.put(i + 1, (byte)green);
            this.drawBuffer.put(i + 2, (byte)red);
            this.drawBuffer.put(i + 3, (byte)alpha);
        }
    }

    @Override
    @Nonnull
    public PixelFormat<ByteBuffer> getPixelFormat() {
        return PixelFormat.getByteBgraPreInstance();
    }
}

