/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import software.coley.bentofx.control.canvas.ArgbSource;
import software.coley.bentofx.control.canvas.PixelPainter;
import software.coley.bentofx.control.canvas.PixelPainterUtils;

public class PixelPainterIntArgb
implements PixelPainter<IntBuffer> {
    protected IntBuffer drawBuffer = PixelPainterUtils.EMPTY_BUFFER_I;
    protected int imageWidth;
    protected int imageHeight;

    @Override
    public boolean initialize(int width, int height) {
        if (this.imageWidth != width || this.imageHeight != height) {
            this.imageWidth = width;
            this.imageHeight = height;
            int drawBufferCapacity = this.drawBufferCapacity();
            if (drawBufferCapacity > this.drawBuffer.limit()) {
                this.drawBuffer = IntBuffer.wrap(new int[drawBufferCapacity]);
                return true;
            }
        }
        this.clear();
        return false;
    }

    @Override
    public void release() {
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.drawBuffer = PixelPainterUtils.EMPTY_BUFFER_I;
    }

    @Override
    public void commit(@Nonnull PixelWriter pixelWriter) {
        pixelWriter.setPixels(0, 0, this.imageWidth, this.imageHeight, this.getPixelFormat(), (Buffer)this.drawBuffer, this.imageWidth);
    }

    @Override
    public void fillRect(int x, int y, int width, int height, int color) {
        int yBound = Math.min(y + height, this.imageHeight);
        int xBound = Math.min(x + width, this.imageWidth);
        IntBuffer drawBuffer = this.drawBuffer;
        int capacity = this.drawBufferCapacity();
        for (int ly = y; ly < yBound; ++ly) {
            int yOffset = ly * this.imageWidth;
            for (int lx = x; lx < xBound; ++lx) {
                int index = yOffset + lx;
                if (index >= capacity) continue;
                drawBuffer.put(index, color);
            }
        }
    }

    @Override
    public void drawImage(int x, int y, @Nonnull ArgbSource source) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int[] argb = source.getArgb();
        int yBound = Math.min(y + sourceHeight, this.imageHeight);
        int xBound = Math.min(x + sourceWidth, this.imageWidth);
        for (int ly = y; ly < yBound; ++ly) {
            int yOffsetSource = (ly - y) * sourceWidth;
            for (int lx = x; lx < xBound; ++lx) {
                int sourceIndex = yOffsetSource + (lx - x);
                if (sourceIndex >= argb.length) continue;
                this.setColor(lx, ly, argb[sourceIndex]);
            }
        }
    }

    @Override
    public void drawImage(int x, int y, int sx, int sy, int sw, int sh, @Nonnull ArgbSource source) {
        int[] argb = source.getArgb(sx, sy, sw, sh);
        if (argb == null) {
            return;
        }
        int yBound = Math.min(y + sh, this.imageHeight);
        int xBound = Math.min(x + sw, this.imageWidth);
        for (int ly = y; ly < yBound; ++ly) {
            int yOffsetSource = (ly - y) * sw;
            for (int lx = x; lx < xBound; ++lx) {
                int sourceIndex = yOffsetSource + (lx - x);
                if (sourceIndex >= argb.length) continue;
                this.setColor(lx, ly, argb[sourceIndex]);
            }
        }
    }

    @Override
    public void setColor(int x, int y, int color) {
        int i = this.adapt(x, y);
        if (i >= 0 && i < this.drawBufferCapacity()) {
            this.drawBuffer.put(i, color);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.drawBuffer.array(), 0, this.drawBufferCapacity(), 0);
    }

    @Override
    @Nonnull
    public IntBuffer getBuffer() {
        return this.drawBuffer;
    }

    @Override
    @Nonnull
    public PixelFormat<IntBuffer> getPixelFormat() {
        return PixelFormat.getIntArgbInstance();
    }

    protected int adapt(int x, int y) {
        return y * this.imageWidth + x;
    }

    protected int drawBufferCapacity() {
        return this.imageWidth * this.imageHeight;
    }
}

