/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control.canvas;

import jakarta.annotation.Nonnull;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;
import software.coley.bentofx.control.canvas.PixelPainterIntArgb;

public class PixelPainterIntArgbPre
extends PixelPainterIntArgb {
    @Override
    public void fillRect(int x, int y, int width, int height, int color) {
        super.fillRect(x, y, width, height, PixelPainterIntArgbPre.argbToArgbPre(color));
    }

    @Override
    public void setColor(int x, int y, int color) {
        super.setColor(x, y, PixelPainterIntArgbPre.argbToArgbPre(color));
    }

    @Override
    @Nonnull
    public PixelFormat<IntBuffer> getPixelFormat() {
        return PixelFormat.getIntArgbPreInstance();
    }

    protected static int argbToArgbPre(int color) {
        int blue;
        int green;
        int red;
        int alpha = color >>> 24;
        if (alpha > 0) {
            red = color >> 16 & 0xFF;
            green = color >> 8 & 0xFF;
            blue = color & 0xFF;
            if (alpha < 255) {
                red = (red * alpha + 127) / 255;
                green = (green * alpha + 127) / 255;
                blue = (blue * alpha + 127) / 255;
            }
        } else {
            blue = 0;
            green = 0;
            red = 0;
        }
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }
}

