/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.dockable;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import software.coley.bentofx.Bento;
import software.coley.bentofx.BentoBacked;
import software.coley.bentofx.Identifiable;
import software.coley.bentofx.dockable.DockableCloseListener;
import software.coley.bentofx.dockable.DockableIconFactory;
import software.coley.bentofx.dockable.DockableMenuFactory;
import software.coley.bentofx.event.DockEvent;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockablePath;

public class Dockable
implements BentoBacked,
Identifiable {
    private final Bento bento;
    private final String identifier;
    private StringProperty title;
    private ObjectProperty<Tooltip> tooltip;
    private ObjectProperty<DockableIconFactory> iconFactory;
    private ObjectProperty<DockableMenuFactory> contextMenuFactory;
    private ObjectProperty<Node> node;
    private ObjectProperty<DockContainerLeaf> container;
    private IntegerProperty dragGroup;
    private BooleanProperty closable;
    private BooleanProperty canBeDragged;
    private BooleanProperty canBeDroppedToNewWindow;
    private List<DockableCloseListener> closeListeners;

    public Dockable(@Nonnull Bento bento, @Nonnull String identifier) {
        this.bento = bento;
        this.identifier = identifier;
    }

    public void fireCloseListeners() {
        if (this.closeListeners != null) {
            DockablePath path = this.getPath();
            if (path == null) {
                return;
            }
            for (DockableCloseListener listener : this.closeListeners) {
                listener.onClose(path, this);
            }
            this.closeListeners = null;
        }
    }

    public void inContainer(@Nonnull Consumer<DockContainerLeaf> consumer) {
        DockContainerLeaf container = this.getContainer();
        if (container != null) {
            consumer.accept(container);
        }
    }

    public void inContainer(@Nonnull BiConsumer<DockContainerLeaf, Dockable> consumer) {
        DockContainerLeaf container = this.getContainer();
        if (container != null) {
            consumer.accept(container, this);
        }
    }

    @Nullable
    public DockablePath getPath() {
        DockContainerLeaf parent = this.getContainer();
        if (parent == null) {
            return null;
        }
        return parent.getPath().withChild(this);
    }

    @Override
    @Nonnull
    public Bento getBento() {
        return this.bento;
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean matchesIdentity(@Nonnull Identifiable other) {
        return this.getIdentifier().equals(other.getIdentifier());
    }

    @Nonnull
    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return (String)this.title.get();
    }

    @Nonnull
    public StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty("");
        }
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.titleProperty().set((Object)Objects.requireNonNullElse(title, ""));
    }

    @Nullable
    public Tooltip getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return (Tooltip)this.tooltip.get();
    }

    @Nonnull
    public ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty();
        }
        return this.tooltip;
    }

    public void setTooltip(@Nullable Tooltip tooltip) {
        this.tooltipProperty().set((Object)tooltip);
    }

    @Nullable
    public DockableIconFactory getIconFactory() {
        if (this.iconFactory == null) {
            return null;
        }
        return (DockableIconFactory)this.iconFactory.get();
    }

    @Nonnull
    public ObjectProperty<DockableIconFactory> iconFactoryProperty() {
        if (this.iconFactory == null) {
            this.iconFactory = new SimpleObjectProperty();
        }
        return this.iconFactory;
    }

    public void setIconFactory(@Nullable DockableIconFactory iconFactory) {
        this.iconFactoryProperty().set((Object)iconFactory);
    }

    @Nullable
    public DockableMenuFactory getContextMenuFactory() {
        if (this.contextMenuFactory == null) {
            return null;
        }
        return (DockableMenuFactory)this.contextMenuFactory.get();
    }

    @Nonnull
    public ObjectProperty<DockableMenuFactory> contextMenuFactoryProperty() {
        if (this.contextMenuFactory == null) {
            this.contextMenuFactory = new SimpleObjectProperty();
        }
        return this.contextMenuFactory;
    }

    public void setContextMenuFactory(@Nullable DockableMenuFactory contextMenuFactory) {
        this.contextMenuFactoryProperty().set((Object)contextMenuFactory);
    }

    @Nullable
    public Node getNode() {
        if (this.node == null) {
            return null;
        }
        return (Node)this.node.get();
    }

    @Nonnull
    public ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty();
        }
        return this.node;
    }

    public void setNode(@Nullable Node node) {
        this.nodeProperty().set((Object)node);
    }

    @Nullable
    public DockContainerLeaf getContainer() {
        if (this.container == null) {
            return null;
        }
        return (DockContainerLeaf)this.container.get();
    }

    @Nonnull
    public ObjectProperty<DockContainerLeaf> containerProperty() {
        if (this.container == null) {
            this.container = new SimpleObjectProperty();
        }
        return this.container;
    }

    public void setContainer(@Nullable DockContainerLeaf container) {
        DockContainerLeaf priorParent = this.getContainer();
        this.containerProperty().set((Object)container);
        this.bento.events().fire(new DockEvent.DockableParentChanged(this, priorParent, container));
    }

    public int getDragGroup() {
        if (this.dragGroup == null) {
            return 0;
        }
        return this.dragGroup.get();
    }

    @Nonnull
    public IntegerProperty dragGroupProperty() {
        if (this.dragGroup == null) {
            this.dragGroup = new SimpleIntegerProperty();
        }
        return this.dragGroup;
    }

    public void setDragGroup(int dragGroup) {
        this.dragGroupProperty().set(dragGroup);
    }

    public boolean isClosable() {
        if (this.closable == null) {
            return true;
        }
        return this.closable.get();
    }

    @Nonnull
    public BooleanProperty closableProperty() {
        if (this.closable == null) {
            this.closable = new SimpleBooleanProperty(true);
        }
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closableProperty().set(closable);
    }

    public boolean isCanBeDragged() {
        if (this.canBeDragged == null) {
            return true;
        }
        return this.canBeDragged.get();
    }

    @Nonnull
    public BooleanProperty canBeDraggedProperty() {
        if (this.canBeDragged == null) {
            this.canBeDragged = new SimpleBooleanProperty();
        }
        return this.canBeDragged;
    }

    public void setCanBeDragged(boolean canBeDragged) {
        this.canBeDraggedProperty().set(canBeDragged);
    }

    public boolean isCanBeDroppedToNewWindow() {
        if (this.canBeDroppedToNewWindow == null) {
            return true;
        }
        return this.canBeDroppedToNewWindow.get();
    }

    @Nonnull
    public BooleanProperty canBeDroppedToNewWindowProperty() {
        if (this.canBeDroppedToNewWindow == null) {
            this.canBeDroppedToNewWindow = new SimpleBooleanProperty();
        }
        return this.canBeDroppedToNewWindow;
    }

    public void setCanBeDroppedToNewWindow(boolean canBeDroppedToNewWindow) {
        this.canBeDroppedToNewWindowProperty().set(canBeDroppedToNewWindow);
    }

    public void addCloseListener(@Nonnull DockableCloseListener listener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<DockableCloseListener>();
        }
        this.closeListeners.add(listener);
    }

    public void removeCloseListener(@Nonnull DockableCloseListener listener) {
        if (this.closeListeners != null) {
            this.closeListeners.remove(listener);
        }
    }

    public String toString() {
        return this.title != null ? this.getTitle() : this.getIdentifier();
    }
}

