/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.event;

import jakarta.annotation.Nonnull;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.dockable.DockableCloseListener;
import software.coley.bentofx.dockable.DockableMoveListener;
import software.coley.bentofx.dockable.DockableOpenListener;
import software.coley.bentofx.dockable.DockableSelectListener;
import software.coley.bentofx.event.DockEvent;
import software.coley.bentofx.event.DockEventListener;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockablePath;

public class EventBus {
    private final List<DockEventListener> eventListeners = new CopyOnWriteArrayList<DockEventListener>();
    private final List<DockableOpenListener> openListeners = new CopyOnWriteArrayList<DockableOpenListener>();
    private final List<DockableMoveListener> moveListeners = new CopyOnWriteArrayList<DockableMoveListener>();
    private final List<DockableCloseListener> closeListeners = new CopyOnWriteArrayList<DockableCloseListener>();
    private final List<DockableSelectListener> selectListeners = new CopyOnWriteArrayList<DockableSelectListener>();

    public void fire(@Nonnull DockEvent event) {
        for (DockEventListener listener : this.eventListeners) {
            listener.onDockEvent(event);
        }
        DockEvent dockEvent = event;
        Objects.requireNonNull(dockEvent);
        DockEvent dockEvent2 = dockEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DockEvent.ContainerChildAdded.class, DockEvent.ContainerChildRemoved.class, DockEvent.ContainerParentChanged.class, DockEvent.DockableAdded.class, DockEvent.DockableClosing.class, DockEvent.DockableParentChanged.class, DockEvent.DockableRemoved.class, DockEvent.DockableSelected.class, DockEvent.RootContainerAdded.class, DockEvent.RootContainerRemoved.class}, (Object)dockEvent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DockEvent.ContainerChildAdded containerChildAdded = (DockEvent.ContainerChildAdded)dockEvent2;
                break;
            }
            case 1: {
                DockEvent.ContainerChildRemoved containerChildRemoved = (DockEvent.ContainerChildRemoved)dockEvent2;
                break;
            }
            case 2: {
                DockEvent.ContainerParentChanged containerParentChanged = (DockEvent.ContainerParentChanged)dockEvent2;
                break;
            }
            case 3: {
                DockEvent.DockableAdded dockableAdded = (DockEvent.DockableAdded)dockEvent2;
                Dockable dockable = dockableAdded.dockable();
                DockablePath path = Objects.requireNonNull(dockable.getPath());
                for (DockableOpenListener listener : this.openListeners) {
                    listener.onOpen(path, dockable);
                }
                break;
            }
            case 4: {
                DockEvent.DockableClosing dockableClosing = (DockEvent.DockableClosing)dockEvent2;
                Dockable dockable = dockableClosing.dockable();
                DockablePath path = Objects.requireNonNull(dockable.getPath());
                for (DockableCloseListener listener : this.closeListeners) {
                    listener.onClose(path, dockable);
                }
                break;
            }
            case 5: {
                DockEvent.DockableParentChanged dockableParentChanged = (DockEvent.DockableParentChanged)dockEvent2;
                DockContainerLeaf priorParent = dockableParentChanged.priorParent();
                DockContainerLeaf newParent = dockableParentChanged.newParent();
                if (priorParent == null || newParent == null) {
                    return;
                }
                Dockable dockable = dockableParentChanged.dockable();
                DockablePath oldPath = priorParent.getPath().withChild(dockable);
                DockablePath newPath = newParent.getPath().withChild(dockable);
                for (DockableMoveListener listener : this.moveListeners) {
                    listener.onMove(oldPath, newPath, dockable);
                }
                break;
            }
            case 6: {
                DockEvent.DockableRemoved dockableRemoved = (DockEvent.DockableRemoved)dockEvent2;
                break;
            }
            case 7: {
                DockEvent.DockableSelected dockableSelected = (DockEvent.DockableSelected)dockEvent2;
                Dockable dockable = dockableSelected.dockable();
                DockablePath path = Objects.requireNonNull(dockable.getPath());
                for (DockableSelectListener listener : this.selectListeners) {
                    listener.onSelect(path, dockable);
                }
                break;
            }
            case 8: {
                DockEvent.RootContainerAdded rootContainerAdded = (DockEvent.RootContainerAdded)dockEvent2;
                break;
            }
            case 9: {
                DockEvent.RootContainerRemoved rootContainerRemoved = (DockEvent.RootContainerRemoved)dockEvent2;
            }
        }
    }

    @Nonnull
    public List<DockEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    public void addEventListener(@Nonnull DockEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeEventListener(@Nonnull DockEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    @Nonnull
    public List<DockableOpenListener> getDockableOpenListener() {
        return Collections.unmodifiableList(this.openListeners);
    }

    public void addDockableOpenListener(@Nonnull DockableOpenListener listener) {
        this.openListeners.add(listener);
    }

    public boolean removeDockableOpenListener(@Nonnull DockableOpenListener listener) {
        return this.openListeners.remove(listener);
    }

    @Nonnull
    public List<DockableMoveListener> getDockableMoveListener() {
        return Collections.unmodifiableList(this.moveListeners);
    }

    public void addDockableMoveListener(@Nonnull DockableMoveListener listener) {
        this.moveListeners.add(listener);
    }

    public boolean removeDockableMoveListener(@Nonnull DockableMoveListener listener) {
        return this.moveListeners.remove(listener);
    }

    @Nonnull
    public List<DockableCloseListener> getDockableCloseListener() {
        return Collections.unmodifiableList(this.closeListeners);
    }

    public void addDockableCloseListener(@Nonnull DockableCloseListener listener) {
        this.closeListeners.add(listener);
    }

    public boolean removeDockableCloseListener(@Nonnull DockableCloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    @Nonnull
    public List<DockableSelectListener> getDockableSelectListener() {
        return Collections.unmodifiableList(this.selectListeners);
    }

    public void addDockableSelectListener(@Nonnull DockableSelectListener listener) {
        this.selectListeners.add(listener);
    }

    public boolean removeDockableSelectListener(@Nonnull DockableSelectListener listener) {
        return this.selectListeners.remove(listener);
    }
}

