/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.layout.container;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Selector;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import software.coley.bentofx.Bento;
import software.coley.bentofx.Identifiable;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.event.DockEvent;
import software.coley.bentofx.layout.DockContainer;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.search.SearchVisitor;
import software.coley.bentofx.util.BentoUtils;

public non-sealed class DockContainerBranch
extends SplitPane
implements DockContainer {
    private static final Selector DIVIDER_SELECTOR = Selector.createSelector((String)".split-pane-divider");
    private final ObservableList<DockContainer> childContainers = FXCollections.observableArrayList();
    private final ObservableList<DockContainer> childContainersView = FXCollections.unmodifiableObservableList(this.childContainers);
    private final Bento bento;
    private final String identifier;
    private List<Runnable> queue;
    private DockContainerBranch parent;
    private boolean pruneWhenEmpty = true;

    public DockContainerBranch(@Nonnull Bento bento, @Nonnull String identifier) {
        this.bento = bento;
        this.identifier = identifier;
        this.getStyleClass().addAll((Object[])new String[]{"bento", "container", "container-branch"});
    }

    @Override
    @Nonnull
    public Bento getBento() {
        return this.bento;
    }

    @Override
    @Nullable
    public DockContainerBranch getParentContainer() {
        return this.parent;
    }

    @Override
    public void setParentContainer(@Nonnull DockContainerBranch parent) {
        DockContainerBranch priorParent = this.parent;
        this.parent = parent;
        this.bento.events().fire(new DockEvent.ContainerParentChanged(this, priorParent, parent));
    }

    @Override
    public void removeAsParentContainer(@Nonnull DockContainerBranch parent) {
        if (this.parent == parent) {
            DockContainerBranch priorParent = this.parent;
            this.parent = null;
            this.bento.events().fire(new DockEvent.ContainerParentChanged(this, priorParent, parent));
        }
    }

    @Override
    public boolean visit(@Nonnull SearchVisitor visitor) {
        if (visitor.visitBranch(this)) {
            for (DockContainer container : this.childContainers) {
                if (container.visit(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean addContainers(DockContainer ... containers) {
        boolean changed = false;
        for (DockContainer container : containers) {
            changed |= this.addContainer(container);
        }
        return changed;
    }

    public boolean addContainer(@Nonnull DockContainer container) {
        return this.addContainer(this.childContainers.size(), container);
    }

    public boolean addContainer(int index, @Nonnull DockContainer container) {
        if (index < 0 || index > this.childContainers.size()) {
            return false;
        }
        if (this.childContainers.contains((Object)container)) {
            return false;
        }
        this.childContainers.add((Object)container);
        container.setParentContainer(this);
        this.getItems().add(index, (Object)container.asRegion());
        this.bento.events().fire(new DockEvent.ContainerChildAdded(this, container));
        return true;
    }

    public boolean replaceContainer(@Nonnull DockContainer child, @Nonnull DockContainer replacement) {
        if (this.childContainers.contains((Object)child)) {
            child.removeAsParentContainer(this);
            int i = this.childContainers.indexOf((Object)child);
            this.childContainers.set(i, (Object)replacement);
            replacement.setParentContainer(this);
            double[] dividers = this.getDividerPositions();
            this.getItems().set(i, (Object)replacement.asRegion());
            this.setDividerPositions(dividers);
            this.bento.events().fire(new DockEvent.ContainerChildRemoved(this, child));
            this.bento.events().fire(new DockEvent.ContainerChildAdded(this, replacement));
            return true;
        }
        return false;
    }

    public boolean removeContainer(@Nonnull DockContainer child) {
        if (this.childContainers.remove((Object)child)) {
            this.getItems().remove((Object)child.asRegion());
            child.removeAsParentContainer(this);
            this.bento.events().fire(new DockEvent.ContainerChildRemoved(this, child));
            if (this.doPruneWhenEmpty()) {
                DockContainerBranch dockContainerBranch;
                if (this.childContainers.isEmpty()) {
                    this.removeFromParent();
                } else if (this.childContainers.size() == 1 && (dockContainerBranch = this.parent) instanceof DockContainerBranch) {
                    DockContainerBranch parentBranch = dockContainerBranch;
                    parentBranch.replaceContainer(this, (DockContainer)this.childContainers.getFirst());
                }
            }
            return true;
        }
        return false;
    }

    public boolean setContainerSizePx(@Nonnull DockContainer child, double size) {
        return this.setContainerSizePx0(child, size, true);
    }

    private boolean setContainerSizePx0(@Nonnull DockContainer child, double size, boolean updateSize) {
        if (this.getScene() == null) {
            this.addQueue(() -> this.setContainerSizePx0(child, size, updateSize));
            return false;
        }
        if (updateSize && this.isContainerCollapsed(child) && child instanceof DockContainerLeaf) {
            DockContainerLeaf leaf = (DockContainerLeaf)child;
            leaf.updateCollapsedSize(size);
            return true;
        }
        int i = this.childContainers.indexOf((Object)child);
        if (i >= 0) {
            Orientation orientation = this.getOrientation();
            Node divider = this.getChildren().stream().filter(arg_0 -> ((Selector)DIVIDER_SELECTOR).applies(arg_0)).findFirst().orElse(null);
            if (divider == null) {
                return false;
            }
            double dividerSize = orientation == Orientation.VERTICAL ? divider.getLayoutBounds().getHeight() : divider.getLayoutBounds().getWidth();
            double adjustedSize = size + dividerSize / 2.0;
            double max = orientation == Orientation.HORIZONTAL ? this.getWidth() : this.getHeight();
            double ratio = Math.clamp(adjustedSize / max, 0.0, 1.0);
            if (i == 0 && this.childContainers.size() > 1) {
                this.setDividerPosition(0, ratio);
            } else if (i > 0 && i == this.childContainers.size() - 1) {
                this.setDividerPosition(i - 1, 1.0 - ratio);
            }
            return true;
        }
        for (DockContainer childContainer : this.childContainers) {
            DockContainerBranch childBranch;
            if (!(childContainer instanceof DockContainerBranch) || !(childBranch = (DockContainerBranch)childContainer).setContainerSizePx0(child, size, updateSize)) continue;
            return true;
        }
        return false;
    }

    public boolean setContainerSizePercent(@Nonnull DockContainer child, double percent) {
        int i = this.childContainers.indexOf((Object)child);
        if (i >= 0) {
            if (i == 0 && this.childContainers.size() > 1) {
                this.setDividerPosition(0, percent);
            } else if (i > 0 && i == this.childContainers.size() - 1) {
                this.setDividerPosition(i - 1, 1.0 - percent);
            }
        } else {
            for (DockContainer childContainer : this.childContainers) {
                DockContainerBranch childBranch;
                if (!(childContainer instanceof DockContainerBranch) || !(childBranch = (DockContainerBranch)childContainer).setContainerSizePercent(child, percent)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainerResizable(@Nonnull DockContainer child) {
        Node divider;
        List<Node> dividers = this.getChildren().stream().filter(arg_0 -> ((Selector)DIVIDER_SELECTOR).applies(arg_0)).toList();
        if (dividers.isEmpty()) {
            return true;
        }
        int i = this.childContainers.indexOf((Object)child);
        if (i == 0 && this.childContainers.size() > 1) {
            divider = dividers.getFirst();
        } else if (i > 0 && i == this.childContainers.size() - 1) {
            divider = dividers.getLast();
        } else {
            return true;
        }
        return !divider.isDisable();
    }

    public boolean setContainerResizable(@Nonnull DockContainer child, boolean resizable) {
        Node divider;
        if (this.getScene() == null) {
            this.addQueue(() -> this.setContainerResizable(child, resizable));
            return false;
        }
        List<Node> dividers = this.getChildren().stream().filter(arg_0 -> ((Selector)DIVIDER_SELECTOR).applies(arg_0)).toList();
        if (dividers.isEmpty()) {
            return false;
        }
        int i = this.childContainers.indexOf((Object)child);
        if (i == 0 && this.childContainers.size() > 1) {
            divider = dividers.getFirst();
        } else if (i > 0 && i == this.childContainers.size() - 1) {
            divider = dividers.getLast();
        } else {
            return false;
        }
        divider.setDisable(!resizable);
        return true;
    }

    public boolean isContainerCollapsed(@Nonnull DockContainer child) {
        DockContainerLeaf leaf;
        return child instanceof DockContainerLeaf && (leaf = (DockContainerLeaf)child).isCollapsed();
    }

    public boolean setContainerCollapsed(@Nonnull DockContainerLeaf child, boolean collapse) {
        DockContainerLeaf adjacentChild;
        Object object;
        int i = this.childContainers.indexOf((Object)child);
        if (i < 0 || i != 0 && i != this.childContainers.size() - 1) {
            return false;
        }
        boolean isCollapsed = child.isCollapsed();
        if (isCollapsed == collapse) {
            return false;
        }
        Orientation orientation = (Orientation)this.orientationProperty().get();
        Side childSide = child.getSide();
        if (childSide == null) {
            return false;
        }
        if (orientation == Orientation.HORIZONTAL && (childSide == Side.TOP || childSide == Side.BOTTOM)) {
            return false;
        }
        if (orientation == Orientation.VERTICAL && (childSide == Side.LEFT || childSide == Side.RIGHT)) {
            return false;
        }
        if (i > 0 && (object = this.childContainers.get(i - 1)) instanceof DockContainerLeaf && (adjacentChild = (DockContainerLeaf)object).isCollapsed()) {
            return false;
        }
        if (i <= this.childContainers.size() - 2 && (object = this.childContainers.get(i + 1)) instanceof DockContainerLeaf && (adjacentChild = (DockContainerLeaf)object).isCollapsed()) {
            return false;
        }
        if (collapse) {
            double collapsedSize = child.getCollapsedSize();
            child.setCollapsedState(true);
            this.setContainerSizePx0(child, collapsedSize, false);
            this.setContainerResizable(child, false);
        } else {
            double originalSize = child.getUncollapsedSize();
            child.setCollapsedState(false);
            this.setContainerSizePx0(child, originalSize, false);
            this.setContainerResizable(child, true);
        }
        return true;
    }

    @Nonnull
    public ObservableList<DockContainer> getChildContainers() {
        return this.childContainersView;
    }

    @Override
    @Nonnull
    public List<Dockable> getDockables() {
        return this.childContainers.stream().flatMap(c -> c.getDockables().stream()).toList();
    }

    @Override
    public boolean addDockable(@Nonnull Dockable dockable) {
        for (DockContainer container : this.childContainers) {
            if (!container.addDockable(dockable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addDockable(int index, @Nonnull Dockable dockable) {
        for (DockContainer container : this.childContainers) {
            if (!container.addDockable(index, dockable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeDockable(@Nonnull Dockable dockable) {
        DockContainer updatedContainer = null;
        for (DockContainer container : this.childContainers) {
            if (!container.removeDockable(dockable)) continue;
            updatedContainer = container;
            break;
        }
        if (updatedContainer != null) {
            if (updatedContainer.doPruneWhenEmpty() && updatedContainer.getDockables().isEmpty()) {
                this.removeContainer(updatedContainer);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean closeDockable(@Nonnull Dockable dockable) {
        DockContainer updatedContainer = null;
        for (DockContainer container : this.childContainers) {
            if (!container.closeDockable(dockable)) continue;
            updatedContainer = container;
            break;
        }
        if (updatedContainer != null) {
            if (updatedContainer.doPruneWhenEmpty() && updatedContainer.getDockables().isEmpty()) {
                this.removeContainer(updatedContainer);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean doPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    @Override
    public void setPruneWhenEmpty(boolean pruneWhenEmpty) {
        this.pruneWhenEmpty = pruneWhenEmpty;
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean matchesIdentity(@Nonnull Identifiable other) {
        return this.identifier.equals(other.getIdentifier());
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.queue != null) {
            this.queue.forEach(Runnable::run);
            this.queue = null;
        }
    }

    private void addQueue(@Nonnull Runnable action) {
        BentoUtils.scheduleWhenShown(this, b -> {
            if (this.queue == null) {
                this.queue = new ArrayList<Runnable>();
            }
            this.queue.add(action);
        });
    }

    public String toString() {
        return "Container-Branch:" + this.getIdentifier();
    }
}

