/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.layout.container;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import software.coley.bentofx.Bento;
import software.coley.bentofx.Identifiable;
import software.coley.bentofx.control.Header;
import software.coley.bentofx.control.HeaderPane;
import software.coley.bentofx.control.canvas.PixelCanvas;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.event.DockEvent;
import software.coley.bentofx.layout.DockContainer;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeafMenuFactory;
import software.coley.bentofx.search.SearchVisitor;
import software.coley.bentofx.util.BentoStates;

public non-sealed class DockContainerLeaf
extends StackPane
implements DockContainer {
    private final ObservableList<Dockable> dockables = FXCollections.observableArrayList();
    private final ObservableList<Dockable> dockablesView = FXCollections.unmodifiableObservableList(this.dockables);
    private final ObjectProperty<Dockable> selectedDockable = new SimpleObjectProperty();
    private final ObjectProperty<Side> side = new SimpleObjectProperty((Object)Side.TOP);
    private final BooleanProperty collapsed = new SimpleBooleanProperty();
    private final ObjectProperty<DockContainerLeafMenuFactory> menuFactory = new SimpleObjectProperty();
    private final DoubleProperty uncollapsedWidth = new SimpleDoubleProperty();
    private final DoubleProperty uncollapsedHeight = new SimpleDoubleProperty();
    private BooleanProperty canSplit;
    private final PixelCanvas canvas;
    private final HeaderPane headerPane;
    private final Bento bento;
    private final String identifier;
    private DockContainerBranch parent;
    private boolean pruneWhenEmpty = true;

    public DockContainerLeaf(@Nonnull Bento bento, @Nonnull String identifier) {
        this.bento = bento;
        this.identifier = identifier;
        this.headerPane = bento.controlsBuilding().newHeaderPane(this);
        this.getStyleClass().addAll((Object[])new String[]{"bento", "container", "container-leaf"});
        this.canvas = bento.controlsBuilding().newCanvas(this);
        this.canvas.setMouseTransparent(true);
        this.canvas.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.uncollapsedWidth.bind((ObservableValue)this.widthProperty());
        this.uncollapsedHeight.bind((ObservableValue)this.heightProperty());
        this.getChildren().addAll((Object[])new Node[]{this.headerPane, this.canvas});
    }

    @Override
    @Nullable
    public DockContainerBranch getParentContainer() {
        return this.parent;
    }

    @Override
    public void setParentContainer(@Nonnull DockContainerBranch parent) {
        DockContainerBranch priorParent = this.parent;
        this.parent = parent;
        this.bento.events().fire(new DockEvent.ContainerParentChanged(this, priorParent, parent));
    }

    @Override
    public void removeAsParentContainer(@Nonnull DockContainerBranch parent) {
        if (this.parent == parent) {
            DockContainerBranch priorParent = this.parent;
            this.parent = null;
            this.bento.events().fire(new DockEvent.ContainerParentChanged(this, priorParent, parent));
        }
    }

    @Override
    public boolean visit(@Nonnull SearchVisitor visitor) {
        if (visitor.visitLeaf(this)) {
            for (Dockable dockable : this.dockables) {
                if (visitor.visitDockable(dockable)) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public ObservableList<Dockable> getDockables() {
        return this.dockablesView;
    }

    @Nullable
    public Dockable getSelectedDockable() {
        return (Dockable)this.selectedDockable.get();
    }

    @Nonnull
    public ObservableObjectValue<Dockable> selectedDockableProperty() {
        return this.selectedDockable;
    }

    public boolean selectDockable(@Nullable Dockable dockable) {
        if (dockable == null) {
            this.selectedDockable.set(null);
            return true;
        }
        if (this.dockables.contains((Object)dockable)) {
            this.selectedDockable.set((Object)dockable);
            if (!this.isFocusWithin()) {
                this.requestFocus();
            }
            this.bento.events().fire(new DockEvent.DockableSelected(dockable, this));
            return true;
        }
        return false;
    }

    @Override
    public boolean addDockable(@Nonnull Dockable dockable) {
        return this.addDockable(this.dockables.size(), dockable);
    }

    @Override
    public boolean addDockable(int index, @Nonnull Dockable dockable) {
        if (this.dockables.contains((Object)dockable)) {
            return false;
        }
        if (index < 0 || index > this.dockables.size()) {
            return false;
        }
        this.dockables.add(index, (Object)dockable);
        dockable.setContainer(this);
        this.bento.events().fire(new DockEvent.DockableAdded(dockable, this));
        if (this.dockables.size() == 1) {
            this.selectDockable(dockable);
        }
        return true;
    }

    @Override
    public boolean removeDockable(@Nonnull Dockable dockable) {
        int i = this.dockables.indexOf((Object)dockable);
        if (i >= 0) {
            this.dockables.remove(i);
            dockable.setContainer(null);
            if (!this.dockables.isEmpty()) {
                Dockable nextSourceDockable = (Dockable)this.dockables.get(Math.min(i, this.dockables.size() - 1));
                this.selectDockable(nextSourceDockable);
            } else {
                this.selectDockable(null);
            }
            this.bento.events().fire(new DockEvent.DockableRemoved(dockable, this));
            if (this.doPruneWhenEmpty() && this.dockables.isEmpty()) {
                this.removeFromParent();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean closeDockable(@Nonnull Dockable dockable) {
        if (dockable.isClosable() && this.dockables.contains((Object)dockable)) {
            dockable.fireCloseListeners();
            this.bento.events().fire(new DockEvent.DockableClosing(dockable, this));
            return this.removeDockable(dockable);
        }
        return false;
    }

    public boolean canReceiveDockable(@Nonnull Dockable dockable, @Nullable Side receivedSide) {
        if (receivedSide == null && this.dockables.contains((Object)dockable)) {
            return false;
        }
        if (this.dockables.isEmpty()) {
            return true;
        }
        return this.dockables.stream().anyMatch(d -> d.getDragGroup() == dockable.getDragGroup());
    }

    @Override
    public boolean doPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    @Override
    public void setPruneWhenEmpty(boolean pruneWhenEmpty) {
        this.pruneWhenEmpty = pruneWhenEmpty;
    }

    public void drawCanvasHint(@Nonnull Region target) {
        this.drawCanvasHint(target, null);
    }

    public void drawCanvasHint(@Nonnull Region target, @Nullable Side side) {
        double ox = 0.0;
        double oy = 0.0;
        for (Parent parent = target.getParent(); parent != null && parent != this; parent = parent.getParent()) {
            ox += parent.getLayoutX();
            oy += parent.getLayoutY();
        }
        this.canvas.clear();
        int color = 0x44FF0000;
        int borderColor = -1996554240;
        int borderWidth = 2;
        double x = ox + target.getLayoutX();
        double y = oy + target.getLayoutY();
        double w = target.getWidth();
        double h = target.getHeight();
        Side side2 = side;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                this.canvas.fillBorderedRect(x, y, w, h / 2.0, 2, 0x44FF0000, -1996554240);
                break;
            }
            case 1: {
                this.canvas.fillBorderedRect(x, y + h / 2.0, w, h / 2.0, 2, 0x44FF0000, -1996554240);
                break;
            }
            case 2: {
                this.canvas.fillBorderedRect(x, y, w / 2.0, h, 2, 0x44FF0000, -1996554240);
                break;
            }
            case 3: {
                this.canvas.fillBorderedRect(x + w / 2.0, y, w / 2.0, h, 2, 0x44FF0000, -1996554240);
                break;
            }
            case -1: {
                this.canvas.fillBorderedRect(x, y, w, h, 2, 0x44FF0000, -1996554240);
            }
        }
        this.canvas.commit();
    }

    public void clearCanvas() {
        this.canvas.clear();
        this.canvas.commit();
    }

    @Nonnull
    public PixelCanvas getCanvas() {
        return this.canvas;
    }

    public boolean isCollapsed() {
        return this.getPseudoClassStates().contains((Object)BentoStates.PSEUDO_COLLAPSED);
    }

    public boolean toggleCollapse(@Nullable Dockable selectedDockable) {
        boolean result;
        if (this.isCollapsed()) {
            this.parent.setContainerCollapsed(this, false);
            result = this.isCollapsed();
            if (!result) {
                this.selectDockable(selectedDockable);
            }
        } else {
            this.parent.setContainerCollapsed(this, true);
            result = this.isCollapsed();
            if (result) {
                this.selectDockable(null);
            }
        }
        return result;
    }

    protected void updateCollapsedSize(double size) {
        if (!this.uncollapsedWidth.isBound()) {
            this.uncollapsedWidth.set(size);
        }
        if (!this.uncollapsedHeight.isBound()) {
            this.uncollapsedHeight.set(size);
        }
    }

    protected void setCollapsedState(boolean collapse) {
        if (collapse) {
            this.selectDockable(null);
            this.uncollapsedWidth.unbind();
            this.uncollapsedHeight.unbind();
        } else {
            this.uncollapsedWidth.bind((ObservableValue)this.widthProperty());
            this.uncollapsedHeight.bind((ObservableValue)this.heightProperty());
        }
        this.collapsed.set(collapse);
        this.pseudoClassStateChanged(BentoStates.PSEUDO_COLLAPSED, collapse);
    }

    protected double getCollapsedSize() {
        Side side = this.getSide();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side, n)) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> Objects.requireNonNull(this.headerPane.getHeaders()).getHeight();
            case 2, 3 -> Objects.requireNonNull(this.headerPane.getHeaders()).getWidth();
            case -1 -> throw new IllegalStateException("Container with null side should not be collapsed");
        };
    }

    protected double getUncollapsedSize() {
        Side side = this.getSide();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side, n)) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> this.uncollapsedHeight.get();
            case 2, 3 -> this.uncollapsedWidth.get();
            case -1 -> throw new IllegalStateException("Container with null side should not be collapsed");
        };
    }

    @Nullable
    public Header getHeader(@Nonnull Dockable dockable) {
        return this.headerPane.getHeader(dockable);
    }

    @Nullable
    public Side getSide() {
        return (Side)this.side.get();
    }

    public void setSide(@Nullable Side side) {
        this.side.set((Object)side);
    }

    @Nonnull
    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    @Nonnull
    public BooleanProperty collapsedProperty() {
        return this.collapsed;
    }

    @Nullable
    public ContextMenu buildContextMenu() {
        DockContainerLeafMenuFactory factory = this.getMenuFactory();
        return factory == null ? null : factory.build(this);
    }

    @Nullable
    public DockContainerLeafMenuFactory getMenuFactory() {
        return (DockContainerLeafMenuFactory)this.menuFactory.get();
    }

    @Nonnull
    public ObjectProperty<DockContainerLeafMenuFactory> menuFactoryProperty() {
        return this.menuFactory;
    }

    public void setMenuFactory(@Nullable DockContainerLeafMenuFactory menuFactory) {
        this.menuFactory.set((Object)menuFactory);
    }

    public boolean isCanSplit() {
        if (this.parent == null) {
            return false;
        }
        if (this.canSplit == null) {
            return true;
        }
        return this.canSplit.get();
    }

    @Nonnull
    public BooleanProperty canSplitProperty() {
        if (this.canSplit == null) {
            this.canSplit = new SimpleBooleanProperty(true);
        }
        return this.canSplit;
    }

    public void setCanSplit(boolean canSplit) {
        this.canSplitProperty().set(canSplit);
    }

    @Override
    @Nonnull
    public Bento getBento() {
        return this.bento;
    }

    @Override
    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean matchesIdentity(@Nonnull Identifiable other) {
        return this.identifier.equals(other.getIdentifier());
    }

    public String toString() {
        return "Container-Leaf:" + this.getIdentifier();
    }
}

