/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.search;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.scene.input.DragEvent;
import software.coley.bentofx.Bento;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.DockContainer;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerRootBranch;
import software.coley.bentofx.path.DockContainerPath;
import software.coley.bentofx.path.DockablePath;
import software.coley.bentofx.search.DockContainerVisitor;
import software.coley.bentofx.search.DockableVisitor;
import software.coley.bentofx.util.DragUtils;

public class SearchHandler {
    private final Bento bento;

    public SearchHandler(@Nonnull Bento bento) {
        this.bento = bento;
    }

    public boolean replaceContainer(@Nonnull String identifier, @Nonnull DockContainer replacement) {
        return this.replaceContainer(identifier, () -> replacement);
    }

    public boolean replaceContainer(@Nonnull String identifier, @Nonnull Supplier<DockContainer> replacement) {
        DockContainerPath container = this.container(identifier);
        if (container == null) {
            return false;
        }
        DockContainer original = container.tailContainer();
        DockContainerBranch parent = original.getParentContainer();
        if (parent == null) {
            return false;
        }
        return parent.replaceContainer(original, replacement.get());
    }

    @Nullable
    public DockContainerPath container(@Nonnull String identifier) {
        return this.container((DockContainer c) -> c.getIdentifier().equals(identifier));
    }

    @Nullable
    public DockContainerPath container(@Nonnull Predicate<DockContainer> predicate) {
        DockContainer container;
        DockContainerVisitor visitor = new DockContainerVisitor(predicate);
        Iterator iterator = this.bento.getRootContainers().iterator();
        while (iterator.hasNext() && (container = (DockContainer)iterator.next()).visit(visitor)) {
        }
        DockContainer result = visitor.getMatchedContainer();
        return result == null ? null : result.getPath();
    }

    @Nullable
    public DockablePath dockable(@Nonnull DragEvent event) {
        String identifier = DragUtils.extractIdentifier(event.getDragboard());
        return identifier == null ? null : this.dockable(identifier);
    }

    @Nullable
    public DockablePath dockable(@Nonnull String identifier) {
        return this.dockable((Dockable d) -> d.getIdentifier().equals(identifier));
    }

    @Nullable
    public DockablePath dockable(@Nonnull Predicate<Dockable> predicate) {
        DockContainer container;
        DockableVisitor visitor = new DockableVisitor(predicate);
        Iterator iterator = this.bento.getRootContainers().iterator();
        while (iterator.hasNext() && (container = (DockContainer)iterator.next()).visit(visitor)) {
        }
        Dockable result = visitor.getMatchedDockable();
        return result == null ? null : result.getPath();
    }

    @Nonnull
    public List<DockablePath> allDockables() {
        ArrayList<DockablePath> paths = new ArrayList<DockablePath>();
        for (DockContainerRootBranch root : this.bento.getRootContainers()) {
            paths.addAll(root.getDockables().stream().map(Dockable::getPath).filter(Objects::nonNull).toList());
        }
        return paths;
    }
}

