/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import software.coley.bentofx.Bento;
import software.coley.bentofx.control.Header;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.path.DockablePath;
import software.coley.bentofx.util.DragDropTarget;

public class DragUtils {
    public static final String PREFIX = "dnd-bento;";

    @Nonnull
    public static Map<DataFormat, Object> content(@Nonnull Dockable dockable) {
        return DragUtils.content(dockable, null);
    }

    @Nonnull
    public static Map<DataFormat, Object> content(@Nonnull Dockable dockable, @Nullable DragDropTarget target) {
        ClipboardContent content = new ClipboardContent();
        String format = PREFIX + dockable.getDragGroup() + ";" + dockable.getIdentifier();
        if (target != null) {
            format = format + ";" + target.name();
        }
        content.putString(format);
        return content;
    }

    public static void completeDnd(@Nonnull DragEvent event, @Nonnull Dockable dockable, @Nonnull DragDropTarget target) {
        event.getDragboard().setContent(DragUtils.content(dockable, target));
        event.consume();
    }

    @Nullable
    public static String extractIdentifier(@Nonnull Dragboard dragboard) {
        if (!dragboard.hasString()) {
            return null;
        }
        String[] parts = dragboard.getString().split(";");
        if (parts.length < 3) {
            return null;
        }
        return parts[2];
    }

    @Nullable
    public static Integer extractDragGroup(@Nonnull Dragboard dragboard) {
        if (!dragboard.hasString()) {
            return null;
        }
        String[] parts = dragboard.getString().split(";");
        if (parts.length < 2) {
            return null;
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public static DragDropTarget extractDropTargetType(@Nonnull Dragboard dragboard) {
        if (!dragboard.hasString()) {
            return null;
        }
        String[] parts = dragboard.getString().split(";");
        if (parts.length < 4) {
            return null;
        }
        try {
            return DragDropTarget.valueOf(parts[3]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Header getHeader(@Nonnull Bento bento, @Nonnull DragEvent event) {
        Object source = event.getGestureSource();
        if (source instanceof Header) {
            Header headerSource = (Header)((Object)source);
            return headerSource;
        }
        if (source != null) {
            return null;
        }
        DockablePath path = bento.search().dockable(event);
        if (path == null) {
            return null;
        }
        return path.leafContainer().getHeader(path.dockable());
    }
}

