/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import software.coley.bentofx.Bento;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockablePath;
import software.coley.bentofx.util.BentoUtils;
import software.coley.bentofx.util.DragDropTarget;
import software.coley.bentofx.util.DragUtils;

public class ContentWrapper
extends BorderPane {
    public ContentWrapper(@Nonnull DockContainerLeaf container) {
        this.getStyleClass().add((Object)"node-wrapper");
        this.setupDragDrop(container);
    }

    protected void setupDragDrop(@Nonnull DockContainerLeaf container) {
        Bento bento = container.getBento();
        this.setOnDragOver(e -> {
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier != null) {
                DockablePath dragSourcePath = bento.search().dockable(dockableIdentifier);
                if (dragSourcePath != null) {
                    Side side;
                    Dockable dragSourceDockable = dragSourcePath.dockable();
                    Side side2 = side = container.isCanSplit() ? BentoUtils.computeClosestSide((Region)this, e.getX(), e.getY()) : null;
                    if (container.canReceiveDockable(dragSourceDockable, side)) {
                        container.drawCanvasHint((Region)this, side);
                    } else {
                        container.clearCanvas();
                    }
                }
                e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            e.consume();
        });
        this.setOnDragExited(e -> container.clearCanvas());
        this.setOnDragDropped(e -> {
            Side side;
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier == null) {
                return;
            }
            DockablePath dragSourcePath = bento.search().dockable(dockableIdentifier);
            if (dragSourcePath == null) {
                return;
            }
            DockContainerLeaf sourceContainer = dragSourcePath.leafContainer();
            Dockable sourceDockable = dragSourcePath.dockable();
            if (container == sourceContainer && container.getDockables().size() == 1) {
                return;
            }
            Side side2 = side = container.isCanSplit() ? BentoUtils.computeClosestSide((Region)this, e.getX(), e.getY()) : null;
            if (container.canReceiveDockable(sourceDockable, side)) {
                boolean pruneState = sourceContainer.doPruneWhenEmpty();
                sourceContainer.setPruneWhenEmpty(false);
                sourceContainer.removeDockable(sourceDockable);
                if (side != null) {
                    DockContainerBranch ourParent = Objects.requireNonNull(container.getParentContainer());
                    DockContainerLeaf containerForDropped = bento.dockBuilding().leaf();
                    containerForDropped.setSide(container.getSide());
                    containerForDropped.addDockable(sourceDockable);
                    DockContainerBranch splitContainer = bento.dockBuilding().branch();
                    if (side == Side.TOP || side == Side.BOTTOM) {
                        splitContainer.setOrientation(Orientation.VERTICAL);
                    }
                    if (side == Side.TOP || side == Side.LEFT) {
                        splitContainer.addContainer(containerForDropped);
                        splitContainer.addContainer(container);
                    } else {
                        splitContainer.addContainer(container);
                        splitContainer.addContainer(containerForDropped);
                    }
                    ourParent.replaceContainer(container, splitContainer);
                } else {
                    container.addDockable(sourceDockable);
                    container.selectDockable(sourceDockable);
                }
                sourceContainer.setPruneWhenEmpty(pruneState);
                if (sourceContainer.doPruneWhenEmpty() && sourceContainer.getDockables().isEmpty()) {
                    sourceContainer.removeFromParent();
                }
                DragUtils.completeDnd(e, sourceDockable, DragDropTarget.REGION);
            }
        });
    }
}

