/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import java.lang.ref.WeakReference;
import java.util.List;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeaf;

public class DragDropStage
extends Stage {
    private final boolean autoCloseWhenEmpty;
    private WeakReference<Parent> content;

    public DragDropStage(boolean autoCloseWhenEmpty) {
        this.autoCloseWhenEmpty = autoCloseWhenEmpty;
        this.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            Parent root = this.getScene().getRoot();
            if (root instanceof DockContainerBranch) {
                DockContainerBranch rootBranch = (DockContainerBranch)root;
                boolean canClose = true;
                List<Dockable> dockables = rootBranch.getDockables();
                for (Dockable dockable : dockables) {
                    DockContainerLeaf container = dockable.getContainer();
                    if (container == null || container.closeDockable(dockable)) continue;
                    canClose = false;
                }
                if (!canClose) {
                    e.consume();
                }
            }
        });
        this.addEventFilter(WindowEvent.WINDOW_HIDDEN, e -> {
            Parent parent = this.getScene().getRoot();
            if (parent != null) {
                this.content = new WeakReference<Parent>(parent);
            }
            this.getScene().setRoot((Parent)new Region());
        });
        this.addEventFilter(WindowEvent.WINDOW_SHOWN, e -> {
            if (this.content != null) {
                this.getScene().setRoot((Parent)this.content.get());
                this.content.clear();
                this.content = null;
            }
        });
    }

    public boolean isAutoCloseWhenEmpty() {
        return this.autoCloseWhenEmpty;
    }
}

