/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import software.coley.bentofx.Bento;
import software.coley.bentofx.control.DragDropStage;
import software.coley.bentofx.control.HeaderPane;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.dockable.DockableMenuFactory;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockablePath;
import software.coley.bentofx.util.BentoStates;
import software.coley.bentofx.util.BentoUtils;
import software.coley.bentofx.util.DragDropTarget;
import software.coley.bentofx.util.DragUtils;

public class Header
extends Region {
    private final StringProperty titleProperty = new SimpleStringProperty();
    private final ObjectProperty<Node> graphicProperty = new SimpleObjectProperty();
    private final BooleanProperty closableProperty = new SimpleBooleanProperty();
    private final ObjectProperty<Side> sideProperty = new SimpleObjectProperty();
    private final ObjectProperty<Tooltip> tooltipProperty = new SimpleObjectProperty();
    private final GridPane grid = new GridPane();
    private final Text label = new Text();
    private final Pane graphicWrapper = new Pane();
    private final Pane closeWrapper = new Pane();
    private final BorderPane ghostWrapper = new BorderPane();
    private final HeaderPane parentPane;
    private final Dockable dockable;

    public Header(@Nonnull Dockable dockable, @Nonnull HeaderPane parentPane) {
        this.parentPane = parentPane;
        this.dockable = dockable;
        this.getStyleClass().add((Object)"header");
        this.ghostWrapper.getStyleClass().add((Object)"dock-ghost-zone");
        this.sideProperty.set((Object)parentPane.getContainer().getSide());
        Side side = this.getSide();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_TOP, true);
                break;
            }
            case 1: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_BOTTOM, true);
                break;
            }
            case 2: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_LEFT, true);
                break;
            }
            case 3: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_RIGHT, true);
            }
            case -1: 
        }
        this.tooltipProperty.addListener((ob, old, cur) -> {
            if (old != null) {
                Tooltip.uninstall((Node)this, (Tooltip)old);
            }
            if (cur != null) {
                Tooltip.install((Node)this, (Tooltip)cur);
            }
        });
        this.setAccessibleRole(AccessibleRole.TAB_ITEM);
        this.setFocusTraversable(true);
        this.setOnKeyPressed(e -> {
            Orientation orientation = BentoUtils.sideToOrientation(this.getSide());
            DockContainerLeaf container = parentPane.getContainer();
            KeyCode code = e.getCode();
            if (orientation == Orientation.HORIZONTAL && code == KeyCode.RIGHT || orientation == Orientation.VERTICAL && code == KeyCode.DOWN) {
                ObservableList<Dockable> dockables = container.getDockables();
                int i = dockables.indexOf(dockable);
                int nextIndex = (i + 1) % dockables.size();
                Dockable nextDockable = (Dockable)dockables.get(nextIndex);
                container.selectDockable(nextDockable);
                Header nextHeader = container.getHeader(nextDockable);
                if (nextHeader != null) {
                    nextHeader.requestFocus();
                }
            } else if (orientation == Orientation.HORIZONTAL && code == KeyCode.LEFT || orientation == Orientation.VERTICAL && code == KeyCode.UP) {
                ObservableList<Dockable> dockables = container.getDockables();
                int i = dockables.indexOf(dockable);
                int prev = i - 1;
                if (prev < 0) {
                    prev = dockables.size() - 1;
                }
                Dockable prevDockable = (Dockable)dockables.get(prev);
                container.selectDockable(prevDockable);
                Header prevHeader = container.getHeader(prevDockable);
                if (prevHeader != null) {
                    prevHeader.requestFocus();
                }
            } else if (code == KeyCode.DELETE) {
                container.closeDockable(dockable);
            } else if (code == KeyCode.ENTER) {
                parentPane.getCenter().requestFocus();
            } else {
                return;
            }
            e.consume();
        });
        this.closableProperty.bind((ObservableValue)dockable.closableProperty());
        this.titleProperty.bind((ObservableValue)dockable.titleProperty());
        this.tooltipProperty.bind(dockable.tooltipProperty());
        this.graphicProperty.bind(dockable.iconFactoryProperty().map(ic -> ic.build(dockable)));
        this.label.textProperty().bind((ObservableValue)this.titleProperty);
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> {
            if (!this.isDisable()) {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_HOVER, true);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, e -> {
            if (!this.isDisable()) {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_HOVER, false);
            }
        });
        Label graphicHolder = new Label();
        graphicHolder.graphicProperty().bind(this.graphicProperty);
        this.graphicWrapper.getChildren().add((Object)graphicHolder);
        this.sideProperty.addListener((ob, old, cur) -> this.recomputeLayout((Side)cur));
        this.closableProperty.addListener((ob, old, cur) -> this.recomputeLayout(this.getSide()));
        this.grid.setHgap(6.0);
        this.grid.setVgap(6.0);
        this.grid.setPadding(new Insets(6.0));
        this.grid.setAlignment(Pos.CENTER);
        BorderPane wrapper = new BorderPane();
        wrapper.setCenter((Node)this.grid);
        wrapper.setLeft((Node)this.ghostWrapper);
        this.getChildren().add((Object)wrapper);
        this.recomputeLayout(this.getSide());
    }

    @Nonnull
    public Header withDragDrop() {
        Bento bento = this.dockable.getBento();
        this.focusedProperty().addListener((ob, old, cur) -> {
            if (cur.booleanValue()) {
                this.parentPane.getContainer().selectDockable(this.dockable);
            }
        });
        this.setOnMouseClicked(e -> {
            ContextMenu menu;
            DockableMenuFactory factory;
            if (e.getButton() == MouseButton.PRIMARY) {
                DockContainerLeaf container = this.parentPane.getContainer();
                if (container.getSelectedDockable() == this.dockable || container.isCollapsed()) {
                    container.toggleCollapse(this.dockable);
                } else if (container.getSelectedDockable() != this.dockable) {
                    container.selectDockable(this.dockable);
                    this.requestFocus();
                }
            }
            if (e.getButton() == MouseButton.SECONDARY && (factory = this.dockable.getContextMenuFactory()) != null && (menu = factory.build(this.dockable)) != null) {
                menu.setAutoHide(true);
                menu.show((Node)this, e.getScreenX(), e.getScreenY());
            }
        });
        Button closeButton = new Button("\u2715");
        closeButton.setFocusTraversable(false);
        closeButton.getStyleClass().add((Object)"close-button");
        closeButton.setOnAction(e -> this.parentPane.getContainer().closeDockable(this.dockable));
        this.closeWrapper.getChildren().add((Object)closeButton);
        this.setOnMouseReleased(e -> {
            if (e.getButton() == MouseButton.MIDDLE && this.getBoundsInLocal().contains(e.getX(), e.getY())) {
                this.parentPane.getContainer().closeDockable(this.dockable);
            }
        });
        this.setOnDragDetected(e -> {
            if (!this.dockable.isCanBeDragged()) {
                return;
            }
            if (e.getButton() == MouseButton.PRIMARY) {
                e.consume();
                WritableImage image = this.snapshot(null, null);
                Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                dragboard.setContent(DragUtils.content(this.dockable));
                dragboard.setDragView((Image)image);
            }
        });
        this.setOnDragOver(e -> {
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier != null) {
                DockablePath dragSourcePath;
                if (!this.dockable.getIdentifier().equals(dockableIdentifier) && (dragSourcePath = bento.search().dockable(dockableIdentifier)) != null) {
                    Dockable dragSourceDockable = dragSourcePath.dockable();
                    DockContainerLeaf container = this.parentPane.getContainer();
                    if (container.canReceiveDockable(dragSourceDockable, this.getSide())) {
                        Header dragSourceHeader = dragSourcePath.leafContainer().getHeader(dragSourceDockable);
                        if (dragSourceHeader != null) {
                            this.enableInsertionGhost(dragSourceHeader);
                        }
                        container.drawCanvasHint((Region)this.ghostWrapper);
                    } else {
                        this.disableInsertionGhost();
                        container.clearCanvas();
                    }
                }
                e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            e.consume();
        });
        this.setOnDragExited(e -> {
            this.disableInsertionGhost();
            this.parentPane.getContainer().clearCanvas();
        });
        this.setOnDragDropped(e -> {
            boolean sameContainer;
            DockContainerLeaf parentContainer = this.dockable.getContainer();
            if (parentContainer == null) {
                return;
            }
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier == null) {
                return;
            }
            if (this.dockable.getIdentifier().equals(dockableIdentifier)) {
                return;
            }
            DockablePath dragSourcePath = bento.search().dockable(dockableIdentifier);
            if (dragSourcePath == null) {
                return;
            }
            DockContainerLeaf sourceContainer = dragSourcePath.leafContainer();
            Dockable sourceDockable = dragSourcePath.dockable();
            boolean bl = sameContainer = parentContainer == sourceContainer;
            if (sameContainer || parentContainer.canReceiveDockable(sourceDockable, this.getSide())) {
                int insertionIndex = parentContainer.getDockables().indexOf((Object)this.dockable);
                if (sameContainer && insertionIndex >= parentContainer.getDockables().indexOf((Object)sourceDockable)) {
                    --insertionIndex;
                }
                sourceContainer.removeDockable(sourceDockable);
                parentContainer.addDockable(insertionIndex, sourceDockable);
                parentContainer.selectDockable(sourceDockable);
                DragUtils.completeDnd(e, sourceDockable, DragDropTarget.HEADER);
            }
        });
        this.setOnDragDone(e -> BentoUtils.scheduleWhenShown(this, h -> {
            Scene scene = this.getScene();
            if (scene.getWindow() instanceof DragDropStage && BentoUtils.getChildren(scene.getRoot(), Header.class).size() == 1) {
                return;
            }
            if (DragUtils.extractDropTargetType(e.getDragboard()) != null) {
                return;
            }
            DockContainerLeaf parentContainer = this.dockable.getContainer();
            if (parentContainer == null) {
                return;
            }
            Scene currentScene = parentContainer.getScene();
            if (e.getGestureTarget() == null && this.dockable.isCanBeDroppedToNewWindow() && parentContainer.removeDockable(this.dockable)) {
                DragDropStage stage = bento.stageBuilding().newStageForDockable(currentScene, parentContainer, this.dockable);
                stage.show();
                stage.toFront();
                stage.requestFocus();
                DragUtils.completeDnd(e, this.dockable, DragDropTarget.EXTERNAL);
            }
        }));
        return this;
    }

    private void recomputeLayout(@Nullable Side side) {
        this.grid.getChildren().clear();
        Side side2 = side;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                this.label.setRotate(0.0);
                this.grid.add((Node)this.graphicWrapper, 0, 0);
                this.grid.add((Node)this.label, 1, 0);
                if (!this.dockable.closableProperty().get()) break;
                this.grid.add((Node)this.closeWrapper, 2, 0);
                break;
            }
            case 2: {
                this.label.setRotate(-90.0);
                this.grid.add((Node)new Group(new Node[]{this.label}), 0, 0);
                this.grid.add((Node)this.graphicWrapper, 0, 1);
                if (!this.dockable.closableProperty().get()) break;
                this.grid.add((Node)this.closeWrapper, 0, 2);
                break;
            }
            case 3: {
                this.label.setRotate(90.0);
                this.grid.add((Node)this.graphicWrapper, 0, 0);
                this.grid.add((Node)new Group(new Node[]{this.label}), 0, 1);
                if (!this.dockable.closableProperty().get()) break;
                this.grid.add((Node)this.closeWrapper, 0, 2);
            }
            case -1: 
        }
        this.requestLayout();
    }

    private void enableInsertionGhost(@Nonnull Header header) {
        this.grid.setMouseTransparent(true);
        this.grid.setManaged(false);
        Orientation ourOrientation = BentoUtils.sideToOrientation(this.getSide());
        Orientation otherOrientation = BentoUtils.sideToOrientation(header.getSide());
        if (ourOrientation == Orientation.HORIZONTAL) {
            this.grid.setTranslateX(otherOrientation == ourOrientation ? header.getLayoutBounds().getWidth() : header.getLayoutBounds().getHeight());
        } else {
            this.grid.setTranslateY(otherOrientation == ourOrientation ? header.getLayoutBounds().getHeight() : header.getLayoutBounds().getWidth());
        }
        this.ghostWrapper.setCenter((Node)new Header(header.dockable, this.parentPane));
        this.getParent().requestLayout();
    }

    private void disableInsertionGhost() {
        this.grid.setMouseTransparent(false);
        this.grid.setManaged(true);
        this.grid.setTranslateX(0.0);
        this.grid.setTranslateY(0.0);
        this.ghostWrapper.setCenter(null);
        this.getParent().requestLayout();
    }

    public void setSelected(boolean selected) {
        this.pseudoClassStateChanged(BentoStates.PSEUDO_SELECTED, selected);
    }

    @Nonnull
    public Dockable getDockable() {
        return this.dockable;
    }

    @Nullable
    private Side getSide() {
        return (Side)this.sideProperty.get();
    }

    public String toString() {
        return "Header:" + (String)this.titleProperty.get();
    }
}

