/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import jakarta.annotation.Nonnull;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class LinearItemPane
extends Pane {
    private static final int MIN_PERPENDICULAR = 16;
    private final Orientation orientation;
    private final BooleanProperty overflowing = new SimpleBooleanProperty();
    private final BooleanProperty fitChildrenToPerpendicular = new SimpleBooleanProperty();
    private final ObjectProperty<Node> keepInView = new SimpleObjectProperty();

    public LinearItemPane(@Nonnull Orientation orientation) {
        this.orientation = orientation;
        this.keepInView.addListener((ob, old, cur) -> this.requestLayout());
        this.fitChildrenToPerpendicular.addListener((ob, old, cur) -> this.requestLayout());
    }

    @Nonnull
    public BooleanProperty overflowingProperty() {
        return this.overflowing;
    }

    @Nonnull
    public ObjectProperty<Node> keepInViewProperty() {
        return this.keepInView;
    }

    @Nonnull
    public BooleanProperty fitChildrenToPerpendicularProperty() {
        return this.fitChildrenToPerpendicular;
    }

    public void add(@Nonnull Node node) {
        this.getChildren().add((Object)node);
    }

    protected void layoutChildren() {
        if (this.orientation == Orientation.HORIZONTAL) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical();
        }
    }

    protected void layoutHorizontal() {
        int maxX = (int)this.getWidth();
        boolean y = false;
        int x = 0;
        Node viewTarget = (Node)this.keepInView.get();
        if (viewTarget != null) {
            double offset = 0.0;
            for (Node child : this.getChildren()) {
                Bounds childBounds = child.getBoundsInParent();
                double childWidth = childBounds.getWidth();
                offset += childWidth;
                if (child != viewTarget) continue;
                if (!(offset > (double)maxX)) break;
                x = (int)((double)maxX - offset);
                break;
            }
        }
        boolean overflow = false;
        for (Node child : this.getChildren()) {
            boolean visible;
            if (child instanceof Parent) {
                Parent childParent = (Parent)child;
                childParent.layout();
            }
            Bounds childBounds = child.getBoundsInParent();
            double childWidth = childBounds.getWidth();
            double childHeight = this.computeChildPerpendicularSize(childBounds, Orientation.HORIZONTAL);
            boolean bl = visible = (double)x + childWidth >= 0.0 && x < maxX;
            if (!child.visibleProperty().isBound()) {
                child.setManaged(visible);
                child.setVisible(visible);
            }
            if (visible) {
                this.layoutInArea(child, x, 0.0, childWidth, childHeight, 0.0, Insets.EMPTY, false, true, HPos.LEFT, VPos.TOP);
            } else {
                overflow = true;
            }
            x += (int)childWidth;
        }
        this.overflowing.set(overflow);
    }

    protected void layoutVertical() {
        int maxY = (int)this.getHeight();
        boolean x = false;
        int y = 0;
        Node viewTarget = (Node)this.keepInView.get();
        if (viewTarget != null) {
            double offset = 0.0;
            for (Node child : this.getChildren()) {
                Bounds childBounds = child.getBoundsInParent();
                double childHeight = childBounds.getHeight();
                offset += childHeight;
                if (child != viewTarget) continue;
                if (!(offset > (double)maxY)) break;
                y = (int)((double)maxY - offset);
                break;
            }
        }
        boolean overflow = false;
        for (Node child : this.getChildren()) {
            boolean visible;
            if (child instanceof Parent) {
                Parent childParent = (Parent)child;
                childParent.layout();
            }
            Bounds childBounds = child.getBoundsInParent();
            double childWidth = this.computeChildPerpendicularSize(childBounds, Orientation.VERTICAL);
            double childHeight = childBounds.getHeight();
            boolean bl = visible = (double)y + childHeight >= 0.0 && y < maxY;
            if (!child.visibleProperty().isBound()) {
                child.setManaged(visible);
                child.setVisible(visible);
            }
            if (visible) {
                this.layoutInArea(child, 0.0, y, childWidth, childHeight, 0.0, Insets.EMPTY, true, false, HPos.LEFT, VPos.TOP);
            } else {
                overflow = true;
            }
            y += (int)childHeight;
        }
        this.overflowing.set(overflow);
    }

    protected double computeChildPerpendicularSize(@Nonnull Bounds childBounds, @Nonnull Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL) {
            return Math.max(this.fitChildrenToPerpendicular.get() ? this.getHeight() : childBounds.getHeight(), 16.0);
        }
        return Math.max(this.fitChildrenToPerpendicular.get() ? this.getWidth() : childBounds.getWidth(), 16.0);
    }
}

