/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.layout;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import javafx.scene.layout.Region;
import software.coley.bentofx.BentoBacked;
import software.coley.bentofx.Identifiable;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockContainerPath;
import software.coley.bentofx.search.SearchVisitor;

public sealed interface DockContainer
extends BentoBacked,
Identifiable
permits DockContainerBranch, DockContainerLeaf {
    @Nonnull
    default public DockContainerPath getPath() {
        DockContainerBranch parent = this.getParentContainer();
        if (parent != null) {
            return parent.getPath().withChild(this);
        }
        return new DockContainerPath(Collections.singletonList(this));
    }

    @Nullable
    public DockContainerBranch getParentContainer();

    public void setParentContainer(@Nonnull DockContainerBranch var1);

    public void removeAsParentContainer(@Nonnull DockContainerBranch var1);

    public boolean visit(@Nonnull SearchVisitor var1);

    @Nonnull
    public List<Dockable> getDockables();

    default public boolean addDockables(Dockable ... dockables) {
        boolean changed = false;
        for (Dockable dockable : dockables) {
            changed |= this.addDockable(dockable);
        }
        return changed;
    }

    public boolean addDockable(@Nonnull Dockable var1);

    public boolean addDockable(int var1, @Nonnull Dockable var2);

    public boolean removeDockable(@Nonnull Dockable var1);

    public boolean closeDockable(@Nonnull Dockable var1);

    default public boolean removeFromParent() {
        DockContainerBranch parent = this.getParentContainer();
        if (parent != null) {
            return parent.removeContainer(this);
        }
        return false;
    }

    public boolean doPruneWhenEmpty();

    public void setPruneWhenEmpty(boolean var1);

    @Nonnull
    default public Region asRegion() {
        return (Region)this;
    }
}

