/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Selector;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;

public class BentoUtils {
    @Nonnull
    public static Orientation sideToOrientation(@Nullable Side side) {
        Side side2 = side;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (Side)side2, n)) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> Orientation.HORIZONTAL;
            case 2, 3 -> Orientation.VERTICAL;
            case -1 -> Orientation.HORIZONTAL;
        };
    }

    @Nullable
    public static Side computeClosestSide(@Nonnull Region target, double x, double y) {
        double w = target.getWidth();
        double h = target.getHeight();
        double mw = w / 2.0;
        double mh = h / 2.0;
        Point2D top = new Point2D(mw, 0.0);
        Point2D bottom = new Point2D(mw, h);
        Point2D left = new Point2D(0.0, mh);
        Point2D right = new Point2D(w, mh);
        Point2D center = new Point2D(mw, mh);
        Point2D[] candidates = new Point2D[]{center, top, bottom, left, right};
        Side[] sides = new Side[]{null, Side.TOP, Side.BOTTOM, Side.LEFT, Side.RIGHT};
        int closest = 0;
        double closestDistance = Double.MAX_VALUE;
        for (int i = 0; i < candidates.length; ++i) {
            Point2D candidate = candidates[i];
            double distance = candidate.distance(x, y);
            if (!(distance < closestDistance)) continue;
            closest = i;
            closestDistance = distance;
        }
        return sides[closest];
    }

    public static <T> List<T> getCastChildren(@Nonnull Parent parent, @Nonnull Class<T> nodeType) {
        return BentoUtils.getChildren(parent, nodeType);
    }

    @Nonnull
    public static List<Node> getChildren(@Nonnull Parent parent, @Nonnull Class<?> nodeType) {
        ArrayList<Node> list = new ArrayList<Node>();
        BentoUtils.visitAndMatchChildren(parent, nodeType, list);
        return list;
    }

    @Nonnull
    public static List<Node> getChildren(@Nonnull Parent parent, @Nonnull String cssSelector) {
        Selector selector = Selector.createSelector((String)cssSelector);
        ArrayList<Node> list = new ArrayList<Node>();
        BentoUtils.visitAndMatchChildren(parent, selector, list);
        return list;
    }

    private static void visitAndMatchChildren(@Nonnull Parent parent, @Nonnull Selector selector, @Nonnull List<Node> list) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (selector.applies((Styleable)node)) {
                list.add(node);
                continue;
            }
            if (!(node instanceof Parent)) continue;
            Parent childParent = (Parent)node;
            BentoUtils.visitAndMatchChildren(childParent, selector, list);
        }
    }

    private static void visitAndMatchChildren(@Nonnull Parent parent, @Nonnull Class<?> nodeType, @Nonnull List<Node> list) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (nodeType.isAssignableFrom(node.getClass())) {
                list.add(node);
                continue;
            }
            if (!(node instanceof Parent)) continue;
            Parent childParent = (Parent)node;
            BentoUtils.visitAndMatchChildren(childParent, nodeType, list);
        }
    }

    public static <T extends Node> void scheduleWhenShown(final @Nonnull T node, final @Nonnull Consumer<T> action) {
        Scene scene = node.getScene();
        if (scene != null) {
            action.accept(node);
            return;
        }
        node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                if (newValue != null) {
                    node.sceneProperty().removeListener((ChangeListener)this);
                    Platform.runLater(() -> action.accept(node));
                }
            }
        });
    }
}

