/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.building;

import jakarta.annotation.Nonnull;
import java.util.Random;
import software.coley.bentofx.Bento;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.layout.container.DockContainerRootBranch;

public class DockBuilding {
    private static final Random RANDOM = new Random();
    private final Bento bento;

    public DockBuilding(@Nonnull Bento bento) {
        this.bento = bento;
    }

    @Nonnull
    public Dockable dockable() {
        return this.dockable(DockBuilding.uid("dockable"));
    }

    @Nonnull
    public Dockable dockable(@Nonnull String identifier) {
        return new Dockable(this.bento, identifier);
    }

    @Nonnull
    public DockContainerRootBranch root() {
        return this.root(DockBuilding.uid("croot"));
    }

    @Nonnull
    public DockContainerRootBranch root(@Nonnull String identifier) {
        return new DockContainerRootBranch(this.bento, identifier);
    }

    @Nonnull
    public DockContainerBranch branch() {
        return this.branch(DockBuilding.uid("cbranch"));
    }

    @Nonnull
    public DockContainerBranch branch(@Nonnull String identifier) {
        return new DockContainerBranch(this.bento, identifier);
    }

    @Nonnull
    public DockContainerLeaf leaf() {
        return this.leaf(DockBuilding.uid("cleaf"));
    }

    @Nonnull
    public DockContainerLeaf leaf(@Nonnull String identifier) {
        return new DockContainerLeaf(this.bento, identifier);
    }

    @Nonnull
    private static String uid(@Nonnull String prefix) {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)RANDOM.nextInt(65, 90));
        }
        return prefix + ":" + String.valueOf(suffix);
    }
}

