/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import software.coley.bentofx.Bento;
import software.coley.bentofx.control.ButtonHBar;
import software.coley.bentofx.control.ButtonVBar;
import software.coley.bentofx.control.ContentWrapper;
import software.coley.bentofx.control.Header;
import software.coley.bentofx.control.Headers;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.util.BentoStates;
import software.coley.bentofx.util.BentoUtils;

public class HeaderPane
extends BorderPane {
    private final DockContainerLeaf container;
    private final ContentWrapper contentWrapper;
    private Headers headers;

    public HeaderPane(@Nonnull DockContainerLeaf container) {
        this.container = container;
        this.contentWrapper = container.getBento().controlsBuilding().newContentWrapper(container);
        this.getStyleClass().add((Object)"header-pane");
        this.setAccessibleRole(AccessibleRole.TAB_PANE);
        container.focusWithinProperty().addListener((ob, old, cur) -> this.pseudoClassStateChanged(BentoStates.PSEUDO_ACTIVE, (boolean)cur));
        this.recomputeLayout(container.getSide());
        container.sideProperty().addListener((ob, old, cur) -> this.recomputeLayout((Side)cur));
        container.selectedDockableProperty().addListener((ob, old, cur) -> {
            Header oldSelectedHeader = this.getHeader((Dockable)old);
            Header newSelectedHeader = this.getHeader((Dockable)cur);
            if (oldSelectedHeader != null) {
                oldSelectedHeader.setSelected(false);
            }
            if (newSelectedHeader != null) {
                newSelectedHeader.setSelected(true);
            }
            if (cur != null) {
                Parent patt0$temp;
                ObjectProperty<Node> dockableNodeProperty = cur.nodeProperty();
                if (dockableNodeProperty.get() != null && (patt0$temp = ((Node)dockableNodeProperty.get()).getParent()) instanceof BorderPane) {
                    BorderPane oldContentWrapper = (BorderPane)patt0$temp;
                    oldContentWrapper.centerProperty().unbind();
                }
                this.contentWrapper.centerProperty().unbind();
                this.contentWrapper.centerProperty().bind(dockableNodeProperty.map(display -> display != null ? display : this.getBento().placeholderBuilding().build((Dockable)cur)));
            } else {
                this.contentWrapper.centerProperty().unbind();
                this.contentWrapper.setCenter(container.isCollapsed() ? null : this.getBento().placeholderBuilding().build(container));
            }
        });
        container.getDockables().addListener(c -> {
            ObservableList headerList = this.headers.getChildren();
            while (c.next()) {
                if (c.wasPermutated()) {
                    headerList.subList(c.getFrom(), c.getTo()).clear();
                    headerList.addAll(c.getFrom(), c.getList().subList(c.getFrom(), c.getTo()).stream().map(this::createHeader).toList());
                    continue;
                }
                if (c.wasRemoved()) {
                    headerList.subList(c.getFrom(), c.getFrom() + c.getRemovedSize()).clear();
                    continue;
                }
                if (!c.wasAdded()) continue;
                headerList.addAll(c.getFrom(), c.getAddedSubList().stream().map(this::createHeader).toList());
            }
        });
        BooleanBinding notCollapsed = container.collapsedProperty().not();
        this.contentWrapper.visibleProperty().bind((ObservableValue)notCollapsed);
        this.contentWrapper.managedProperty().bind((ObservableValue)notCollapsed);
        this.setCenter((Node)this.contentWrapper);
    }

    private void recomputeLayout(@Nullable Side side) {
        this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_TOP, false);
        this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_BOTTOM, false);
        this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_LEFT, false);
        this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_RIGHT, false);
        this.setTop(null);
        this.setBottom(null);
        this.setLeft(null);
        this.setRight(null);
        if (side == null) {
            return;
        }
        this.headers = this.getBento().controlsBuilding().newHeaders(this.container, BentoUtils.sideToOrientation(side), side);
        Button dockableListButton = this.createDockableListButton();
        Button containerConfigButton = this.createContainerConfigButton();
        BorderPane headersWrapper = new BorderPane((Node)this.headers);
        headersWrapper.getStyleClass().add((Object)"header-region-wrapper");
        if (BentoUtils.sideToOrientation(side) == Orientation.HORIZONTAL) {
            headersWrapper.setRight((Node)new ButtonHBar((Region)this.headers, new Node[]{dockableListButton, containerConfigButton}));
        } else {
            headersWrapper.setBottom((Node)new ButtonVBar((Region)this.headers, new Node[]{dockableListButton, containerConfigButton}));
        }
        switch (side) {
            case TOP: {
                this.setTop((Node)headersWrapper);
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_TOP, true);
                break;
            }
            case BOTTOM: {
                this.setBottom((Node)headersWrapper);
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_BOTTOM, true);
                break;
            }
            case LEFT: {
                this.setLeft((Node)headersWrapper);
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_LEFT, true);
                break;
            }
            case RIGHT: {
                this.setRight((Node)headersWrapper);
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_RIGHT, true);
            }
        }
        this.container.getDockables().stream().map(d -> {
            Header header = this.createHeader((Dockable)d);
            if (this.container.getSelectedDockable() == d) {
                header.setSelected(true);
            }
            return header;
        }).forEach(this.headers::add);
    }

    @Nonnull
    private Button createDockableListButton() {
        Button button = new Button("\u25bc");
        button.setEllipsisString("\u25bc");
        button.getStyleClass().addAll((Object[])new String[]{"corner-button", "list-button"});
        button.setOnMousePressed(e -> {
            ContextMenu menu = new ContextMenu();
            menu.getItems().addAll(this.container.getDockables().stream().map(d -> {
                MenuItem item = new MenuItem();
                item.textProperty().bind((ObservableValue)d.titleProperty());
                item.graphicProperty().bind(d.iconFactoryProperty().map(ic -> ic.build((Dockable)d)));
                item.setOnAction(ignored -> this.container.selectDockable((Dockable)d));
                return item;
            }).toList());
            button.setContextMenu(menu);
        });
        button.setOnMouseClicked(e -> button.getContextMenu().show((Node)button, e.getScreenX(), e.getScreenY()));
        button.visibleProperty().bind((ObservableValue)this.headers.overflowingProperty());
        button.managedProperty().bind((ObservableValue)button.visibleProperty());
        return button;
    }

    @Nonnull
    private Button createContainerConfigButton() {
        Button button = new Button("\u2261");
        button.setEllipsisString("\u2261");
        button.getStyleClass().addAll((Object[])new String[]{"corner-button", "context-button"});
        button.setOnMousePressed(e -> button.setContextMenu(this.container.buildContextMenu()));
        button.setOnMouseClicked(e -> button.getContextMenu().show((Node)button, e.getScreenX(), e.getScreenY()));
        button.visibleProperty().bind((ObservableValue)this.container.menuFactoryProperty().isNotNull());
        button.managedProperty().bind((ObservableValue)button.visibleProperty());
        return button;
    }

    @Nonnull
    private Header createHeader(@Nonnull Dockable dockable) {
        return this.getBento().controlsBuilding().newHeader(dockable, this);
    }

    @Nullable
    public Header getHeader(@Nullable Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        for (Node child : this.headers.getChildren()) {
            Header header;
            if (!(child instanceof Header) || (header = (Header)child).getDockable() != dockable) continue;
            return header;
        }
        return null;
    }

    @Nonnull
    public DockContainerLeaf getContainer() {
        return this.container;
    }

    @Nonnull
    public ContentWrapper getContentWrapper() {
        return this.contentWrapper;
    }

    @Nullable
    public Headers getHeaders() {
        return this.headers;
    }

    @Nonnull
    private Bento getBento() {
        return this.container.getBento();
    }
}

