/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.control;

import jakarta.annotation.Nonnull;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import software.coley.bentofx.control.LinearItemPane;
import software.coley.bentofx.dockable.Dockable;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.path.DockablePath;
import software.coley.bentofx.util.BentoStates;
import software.coley.bentofx.util.DragDropTarget;
import software.coley.bentofx.util.DragUtils;

public class Headers
extends LinearItemPane {
    public Headers(@Nonnull DockContainerLeaf container, @Nonnull Orientation orientation, @Nonnull Side side) {
        super(orientation);
        this.getStyleClass().add((Object)"header-region");
        switch (side) {
            case TOP: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_TOP, true);
                break;
            }
            case BOTTOM: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_BOTTOM, true);
                break;
            }
            case LEFT: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_LEFT, true);
                break;
            }
            case RIGHT: {
                this.pseudoClassStateChanged(BentoStates.PSEUDO_SIDE_RIGHT, true);
            }
        }
        if (orientation == Orientation.HORIZONTAL) {
            this.prefWidthProperty().bind((ObservableValue)container.widthProperty());
        } else {
            this.prefHeightProperty().bind((ObservableValue)container.heightProperty());
        }
        this.fitChildrenToPerpendicularProperty().set(true);
        this.keepInViewProperty().bind(container.selectedDockableProperty().map(container::getHeader));
        this.setupDragDrop(container);
    }

    protected void setupClip() {
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
    }

    protected void setupDragDrop(@Nonnull DockContainerLeaf container) {
        this.setOnDragOver(e -> {
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier != null) {
                DockablePath dragSourcePath = container.getBento().search().dockable(dockableIdentifier);
                if (dragSourcePath != null) {
                    Dockable dragSourceDockable = dragSourcePath.dockable();
                    if (container.canReceiveDockable(dragSourceDockable, null)) {
                        container.drawCanvasHint((Region)this);
                    } else {
                        container.clearCanvas();
                    }
                }
                e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            e.consume();
        });
        this.setOnDragDropped(e -> {
            Dragboard dragboard = e.getDragboard();
            String dockableIdentifier = DragUtils.extractIdentifier(dragboard);
            if (dockableIdentifier == null) {
                return;
            }
            DockablePath dragSourcePath = container.getBento().search().dockable(dockableIdentifier);
            if (dragSourcePath == null) {
                return;
            }
            DockContainerLeaf sourceContainer = dragSourcePath.leafContainer();
            Dockable sourceDockable = dragSourcePath.dockable();
            if (container.canReceiveDockable(sourceDockable, null)) {
                sourceContainer.removeDockable(sourceDockable);
                container.addDockable(sourceDockable);
                container.selectDockable(sourceDockable);
                DragUtils.completeDnd(e, sourceDockable, DragDropTarget.REGION);
            }
        });
        this.setOnDragExited(e -> container.clearCanvas());
    }
}

