/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.layout.container;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import software.coley.bentofx.Bento;
import software.coley.bentofx.control.DragDropStage;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.path.DockContainerPath;
import software.coley.bentofx.util.BentoStates;

public class DockContainerRootBranch
extends DockContainerBranch {
    private final DockContainerPath path = new DockContainerPath(Collections.singletonList(this));

    public DockContainerRootBranch(@Nonnull Bento bento, @Nonnull String identifier) {
        super(bento, identifier);
        this.pseudoClassStateChanged(BentoStates.PSEUDO_ROOT, true);
        this.sceneProperty().addListener((on, old, cur) -> {
            if (cur != null) {
                bento.registerRoot(this);
            } else {
                bento.unregisterRoot(this);
            }
        });
    }

    @Override
    public boolean removeFromParent() {
        DragDropStage ddStage;
        Window window;
        Region thisAsRegion = this.asRegion();
        Scene scene = thisAsRegion.getScene();
        if (scene != null && scene.getRoot() == thisAsRegion && (window = scene.getWindow()) instanceof DragDropStage && (ddStage = (DragDropStage)window).isAutoCloseWhenEmpty()) {
            ddStage.close();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DockContainerBranch getParentContainer() {
        return null;
    }

    @Override
    public void setParentContainer(@Nonnull DockContainerBranch parent) {
        throw new IllegalStateException("Root should not have a parent container assigned");
    }

    @Override
    @Nonnull
    public DockContainerPath getPath() {
        return this.path;
    }
}

