/*
 * Decompiled with CFR 0.152.
 */
package software.coley.bentofx.search;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;
import software.coley.bentofx.layout.DockContainer;
import software.coley.bentofx.layout.container.DockContainerBranch;
import software.coley.bentofx.layout.container.DockContainerLeaf;
import software.coley.bentofx.search.SearchVisitor;

public class DockContainerVisitor
implements SearchVisitor {
    private final Predicate<DockContainer> matcher;
    private DockContainer result;

    public DockContainerVisitor(@Nonnull Predicate<DockContainer> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean visitBranch(@Nonnull DockContainerBranch container) {
        return this.visitContainer(container);
    }

    @Override
    public boolean visitLeaf(@Nonnull DockContainerLeaf container) {
        return this.visitContainer(container);
    }

    private boolean visitContainer(@Nonnull DockContainer container) {
        if (this.matcher.test(container)) {
            this.result = container;
            return false;
        }
        return true;
    }

    @Nullable
    public DockContainer getMatchedContainer() {
        return this.result;
    }
}

